/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.client.model.loader.base.HaloSetting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public abstract class BaseModelLoader<T extends IUnbakedGeometry<T>>
implements IGeometryLoader<T> {
    public JsonObject clear(JsonObject modelContents, String ... types) {
        JsonObject clean = modelContents.deepCopy();
        clean.remove("loader");
        for (String type : types) {
            clean.remove(type);
        }
        return clean;
    }

    public List<ResourceLocation> getMasks(JsonObject modelContents, String type) {
        JsonObject cosmic = modelContents.getAsJsonObject(type);
        if (cosmic == null) {
            throw new IllegalStateException("Missing " + type + " object.");
        }
        ArrayList<ResourceLocation> maskTexture = new ArrayList<ResourceLocation>();
        if (cosmic.has("mask") && cosmic.get("mask").isJsonArray()) {
            JsonArray masks = cosmic.getAsJsonArray("mask");
            for (int i = 0; i < masks.size(); ++i) {
                maskTexture.add(new ResourceLocation(masks.get(i).getAsString()));
            }
        } else {
            maskTexture.add(new ResourceLocation(GsonHelper.getAsString((JsonObject)cosmic, (String)"mask")));
        }
        return maskTexture;
    }

    public HaloSetting getHalo(JsonObject modelContents) {
        JsonObject halo = modelContents.getAsJsonObject("halo");
        if (halo == null) {
            throw new IllegalStateException("Missing 'halo' object.");
        }
        IntArrayList layerColors = new IntArrayList();
        JsonArray layerColorsArr = modelContents.getAsJsonArray("layerColors");
        if (layerColorsArr != null) {
            for (JsonElement jsonElement : layerColorsArr) {
                layerColors.add(jsonElement.getAsInt());
            }
        }
        String texture = GsonHelper.getAsString((JsonObject)halo, (String)"texture");
        int color = GsonHelper.getAsInt((JsonObject)halo, (String)"color");
        int size = GsonHelper.getAsInt((JsonObject)halo, (String)"size");
        boolean pulse = GsonHelper.getAsBoolean((JsonObject)halo, (String)"pulse");
        return new HaloSetting(layerColors, texture, color, size, pulse);
    }
}

