/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader.base;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import committee.nova.mods.avaritia.api.client.model.CachedFormat;
import committee.nova.mods.avaritia.api.client.model.IVertexConsumer;
import committee.nova.mods.avaritia.api.client.model.Quad;
import committee.nova.mods.avaritia.api.client.util.color.ColorARGB;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraftforge.client.RenderTypeGroup;
import org.apache.commons.lang3.tuple.Pair;

public class HaloUtils {
    private static final int[] DEFAULT_MAPPING = HaloUtils.generateMapping(DefaultVertexFormat.BLOCK, DefaultVertexFormat.BLOCK);
    private static final ConcurrentMap<Pair<VertexFormat, VertexFormat>, int[]> formatMaps = new ConcurrentHashMap<Pair<VertexFormat, VertexFormat>, int[]>();

    public static BakedQuad generateHaloQuad(TextureAtlasSprite sprite, int size, int color) {
        float[] colors = new ColorARGB(color).getRGBA();
        double spread = (double)size / 16.0;
        double min = 0.0 - spread;
        double max = 1.0 + spread;
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        Quad quad = new Quad();
        quad.reset(CachedFormat.BLOCK);
        quad.setTexture(sprite);
        HaloUtils.putVertex(quad.vertices[0], max, max, 0.0, maxU, minV);
        HaloUtils.putVertex(quad.vertices[1], min, max, 0.0, minU, minV);
        HaloUtils.putVertex(quad.vertices[2], min, min, 0.0, minU, maxV);
        HaloUtils.putVertex(quad.vertices[3], max, min, 0.0, maxU, maxV);
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(colors, 0, quad.vertices[i].color, 0, 4);
        }
        quad.calculateOrientation(true);
        return quad.bake();
    }

    public static void putVertex(Quad.Vertex vx, double x, double y, double z, double u, double v) {
        vx.vec[0] = (float)x;
        vx.vec[1] = (float)y;
        vx.vec[2] = (float)z;
        vx.uv[0] = (float)u;
        vx.uv[1] = (float)v;
    }

    public static BakedModel tintLayers(BakedModel model, IntList layerColors) {
        if (layerColors.isEmpty()) {
            return model;
        }
        HashMap<Direction, List<BakedQuad>> faceQuads = new HashMap<Direction, List<BakedQuad>>();
        for (Direction face : Direction.values()) {
            faceQuads.put(face, HaloUtils.transformQuads(model.getQuads(null, face, RandomSource.create()), layerColors));
        }
        List<BakedQuad> unculled = HaloUtils.transformQuads(model.getQuads(null, null, RandomSource.create()), layerColors);
        return new SimpleBakedModel(unculled, faceQuads, model.useAmbientOcclusion(), model.usesBlockLight(), model.isGui3d(), model.getParticleIcon(), model.getTransforms(), ItemOverrides.EMPTY, RenderTypeGroup.EMPTY);
    }

    public static List<BakedQuad> transformQuads(List<BakedQuad> quads, IntList layerColors) {
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            newQuads.add(HaloUtils.transformQuad(quad, layerColors));
        }
        return newQuads;
    }

    public static int[] mapFormats(VertexFormat from, VertexFormat to) {
        if (from.equals((Object)DefaultVertexFormat.BLOCK) && to.equals((Object)DefaultVertexFormat.BLOCK)) {
            return DEFAULT_MAPPING;
        }
        return formatMaps.computeIfAbsent((Pair<VertexFormat, VertexFormat>)Pair.of((Object)from, (Object)to), pair -> HaloUtils.generateMapping((VertexFormat)pair.getLeft(), (VertexFormat)pair.getRight()));
    }

    public static void unpack(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
        int length = Math.min(4, to.length);
        VertexFormatElement element = (VertexFormatElement)formatFrom.getElements().get(e);
        int vertexStart = v * formatFrom.getVertexSize() + formatFrom.getOffset(e);
        int count = element.getElementCount();
        VertexFormatElement.Type type = element.getType();
        VertexFormatElement.Usage usage = element.getUsage();
        int size = type.getSize();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == VertexFormatElement.Type.FLOAT) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == VertexFormatElement.Type.UINT) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == VertexFormatElement.Type.BYTE) {
                    to[i] = (float)((byte)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type == VertexFormatElement.Type.SHORT) {
                    to[i] = (float)((short)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type != VertexFormatElement.Type.INT) continue;
                to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                continue;
            }
            to[i] = i == 3 && usage == VertexFormatElement.Usage.POSITION ? 1.0f : 0.0f;
        }
    }

    private static int[] generateMapping(VertexFormat from, VertexFormat to) {
        int fromCount = from.getElements().size();
        int toCount = to.getElements().size();
        int[] eMap = new int[fromCount];
        for (int e = 0; e < fromCount; ++e) {
            int e2;
            VertexFormatElement expected = (VertexFormatElement)from.getElements().get(e);
            for (e2 = 0; e2 < toCount; ++e2) {
                VertexFormatElement current = (VertexFormatElement)to.getElements().get(e2);
                if (expected.getUsage() == current.getUsage() && expected.getIndex() == current.getIndex()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }

    public static void putBakedQuad(IVertexConsumer consumer, BakedQuad quad) {
        consumer.setTexture(quad.getSprite());
        consumer.setQuadOrientation(quad.getDirection());
        if (quad.isTinted()) {
            consumer.setQuadTint(quad.getTintIndex());
        }
        consumer.setApplyDiffuseLighting(quad.isShade());
        float[] data = new float[4];
        VertexFormat formatFrom = consumer.getVertexFormat();
        VertexFormat formatTo = DefaultVertexFormat.BLOCK;
        int countFrom = formatFrom.getElements().size();
        int countTo = formatTo.getElements().size();
        int[] eMap = HaloUtils.mapFormats(formatFrom, formatTo);
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    HaloUtils.unpack(quad.getVertices(), data, formatTo, v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static BakedQuad transformQuad(BakedQuad quad, IntList layerColors) {
        int tintIndex = quad.getTintIndex();
        if (tintIndex == -1 || tintIndex >= layerColors.size()) {
            return quad;
        }
        int tint = layerColors.getInt(tintIndex);
        if (tint == -1) {
            return quad;
        }
        Quad newQuad = new Quad();
        newQuad.reset(CachedFormat.BLOCK);
        HaloUtils.putBakedQuad(newQuad, quad);
        float r = (float)(tint >> 16 & 0xFF) / 255.0f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f;
        float b = (float)(tint & 0xFF) / 255.0f;
        for (Quad.Vertex v : newQuad.vertices) {
            v.color[0] = v.color[0] * r;
            v.color[1] = v.color[1] * g;
            v.color[2] = v.color[2] * b;
        }
        newQuad.tintIndex = -1;
        return newQuad.bake();
    }
}

