/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import committee.nova.mods.avaritia.init.registry.ModParticles;
import java.util.Optional;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ShockwaveParticleOptions
extends DustParticleOptionsBase {
    protected final float unclampedScale;
    protected final boolean fullbright;
    protected final String trailParticleRaw;
    public static final Codec<ShockwaveParticleOptions> CODEC = RecordCodecBuilder.create(p_175793_ -> p_175793_.group((App)ExtraCodecs.VECTOR3F.fieldOf("color").forGetter(option -> option.color), (App)Codec.FLOAT.fieldOf("scale").forGetter(option -> Float.valueOf(option.unclampedScale)), (App)Codec.BOOL.fieldOf("fullbright").forGetter(option -> option.fullbright), (App)Codec.STRING.fieldOf("particle").forGetter(option -> option.trailParticleRaw)).apply((Applicative)p_175793_, ShockwaveParticleOptions::new));
    public static final ParticleOptions.Deserializer<ShockwaveParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ShockwaveParticleOptions>(){

        @NotNull
        public ShockwaveParticleOptions fromCommand(@NotNull ParticleType<ShockwaveParticleOptions> p_123689_, @NotNull StringReader reader) throws CommandSyntaxException {
            Vector3f vector3f = DustParticleOptionsBase.readVector3f((StringReader)reader);
            reader.expect(' ');
            float f = reader.readFloat();
            reader.expect(' ');
            boolean glowing = reader.readBoolean();
            reader.expect(' ');
            String particle = reader.readString();
            return new ShockwaveParticleOptions(vector3f, f, glowing, particle);
        }

        @NotNull
        public ShockwaveParticleOptions fromNetwork(@NotNull ParticleType<ShockwaveParticleOptions> p_123692_, @NotNull FriendlyByteBuf buf) {
            return new ShockwaveParticleOptions(DustParticleOptionsBase.readVector3f((FriendlyByteBuf)buf), buf.readFloat(), buf.readBoolean(), buf.readUtf());
        }
    };

    public ShockwaveParticleOptions(Vector3f color, float scale, boolean glowing, String trailParticle) {
        super(color, scale);
        this.unclampedScale = scale;
        this.fullbright = glowing;
        this.trailParticleRaw = trailParticle;
    }

    public ShockwaveParticleOptions(Vector3f color, float scale, boolean glowing) {
        this(color, scale, glowing, "");
    }

    public float getScale() {
        return this.unclampedScale;
    }

    public boolean isFullbright() {
        return this.fullbright;
    }

    public Optional<ParticleOptions> trailParticle() {
        try {
            ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ResourceLocation.tryParse((String)this.trailParticleRaw));
            if (type instanceof ParticleOptions) {
                ParticleOptions particleOptions = (ParticleOptions)type;
                return Optional.of(particleOptions);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public Vector3f color() {
        return this.color;
    }

    public void writeToNetwork(FriendlyByteBuf pBuffer) {
        pBuffer.writeFloat(this.color.x());
        pBuffer.writeFloat(this.color.y());
        pBuffer.writeFloat(this.color.z());
        pBuffer.writeFloat(this.unclampedScale);
        pBuffer.writeBoolean(this.fullbright);
        pBuffer.writeUtf(this.trailParticleRaw);
    }

    @NotNull
    public ParticleType<ShockwaveParticleOptions> getType() {
        return (ParticleType)ModParticles.SHOCKWAVE_PARTICLE.get();
    }
}

