/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.init.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class AvaritiaConfigScreen
extends Screen {
    private final Screen parent;
    private final List<ConfigEntry<?>> configEntries = new ArrayList();
    private int scrollOffset = 0;
    private static final int ENTRY_HEIGHT = 40;
    private static final int MARGIN = 20;
    private static final int START_Y = 50;
    private Button resetButton;
    private Button backButton;
    private boolean isDraggingScrollbar = false;
    private int scrollbarX;
    private int scrollbarY;
    private int scrollbarHeight;
    private int scrollbarHandleHeight;
    private int maxScrollOffset;
    private double scrollVelocity = 0.0;
    private long lastScrollTime = 0L;
    private static final double FRICTION = 0.92;
    private static final double MIN_VELOCITY = 0.1;
    private static final double SCROLL_FACTOR = 10.0;

    public AvaritiaConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"title.avaritia.config.title"));
        this.parent = parent;
        this.initConfigEntries();
    }

    private void initConfigEntries() {
        this.addCategoryHeader("config.avaritia.category.tools");
        this.addBooleanEntry("is_keep_stone", ModConfig.isKeepStone, (Component)Component.translatable((String)"config.avaritia.is_keep_stone.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.isKeepStone).set(arg_0), (Supplier<Boolean>)ModConfig.isKeepStone);
        this.addBooleanEntry("is_merge_matter_cluster", ModConfig.isMergeMatterCluster, (Component)Component.translatable((String)"config.avaritia.is_merge_matter_cluster.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.isMergeMatterCluster).set(arg_0), (Supplier<Boolean>)ModConfig.isMergeMatterCluster);
        this.addIntEntry("sword_range_damage", ModConfig.swordRangeDamage, 100, 100000, (Component)Component.translatable((String)"config.avaritia.sword_range_damage.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.swordRangeDamage).set(arg_0), (Supplier<Integer>)ModConfig.swordRangeDamage);
        this.addIntEntry("sword_attack_range", ModConfig.swordAttackRange, 8, 64, (Component)Component.translatable((String)"config.avaritia.sword_attack_range.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.swordAttackRange).set(arg_0), (Supplier<Integer>)ModConfig.swordAttackRange);
        this.addBooleanEntry("is_sword_attack_item_entity", ModConfig.isSwordAttackItemEntity, (Component)Component.translatable((String)"config.avaritia.is_sword_attack_item_entity.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.isSwordAttackItemEntity).set(arg_0), (Supplier<Boolean>)ModConfig.isSwordAttackItemEntity);
        this.addBooleanEntry("is_sword_attack_lightning", ModConfig.isSwordAttackLightning, (Component)Component.translatable((String)"config.avaritia.is_sword_attack_lightning.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.isSwordAttackLightning).set(arg_0), (Supplier<Boolean>)ModConfig.isSwordAttackLightning);
        this.addBooleanEntry("is_sword_attack_endless", ModConfig.isSwordAttackEndless, (Component)Component.translatable((String)"config.avaritia.is_sword_attack_endless.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.isSwordAttackEndless).set(arg_0), (Supplier<Boolean>)ModConfig.isSwordAttackEndless);
        this.addIntEntry("sub_arrow_damage", ModConfig.subArrowDamage, 100, 100000, (Component)Component.translatable((String)"config.avaritia.sub_arrow_damage.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.subArrowDamage).set(arg_0), (Supplier<Integer>)ModConfig.subArrowDamage);
        this.addIntEntry("axe_chain_count", ModConfig.axeChainCount, 16, 128, (Component)Component.translatable((String)"config.avaritia.axe_chain_count.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.axeChainCount).set(arg_0), (Supplier<Integer>)ModConfig.axeChainCount);
        this.addDoubleEntry("food_time", ModConfig.foodTime, 0.1, 5.0, (Component)Component.translatable((String)"config.avaritia.food_time.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.foodTime).set(arg_0), (Supplier<Double>)ModConfig.foodTime);
        this.addIntEntry("pickaxe_break_range", ModConfig.pickAxeBreakRange, 2, 32, (Component)Component.translatable((String)"config.avaritia.pickaxe_break_range.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.pickAxeBreakRange).set(arg_0), (Supplier<Integer>)ModConfig.pickAxeBreakRange);
        this.addIntEntry("shovel_break_range", ModConfig.shovelBreakRange, 2, 32, (Component)Component.translatable((String)"config.avaritia.shovel_break_range.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.shovelBreakRange).set(arg_0), (Supplier<Integer>)ModConfig.shovelBreakRange);
        this.addIntEntry("neutron_collector_product_tick", ModConfig.neutronCollectorProductTick, 1200, Integer.MAX_VALUE, (Component)Component.translatable((String)"config.avaritia.neutron_collector_product_tick.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.neutronCollectorProductTick).set(arg_0), (Supplier<Integer>)ModConfig.neutronCollectorProductTick);
        this.addIntEntry("singularity_time_required", ModConfig.singularityTimeRequired, 0, Integer.MAX_VALUE, (Component)Component.translatable((String)"config.avaritia.singularity_time_required.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.singularityTimeRequired).set(arg_0), (Supplier<Integer>)ModConfig.singularityTimeRequired);
        this.addDoubleEntry("growth_soul_farmland", ModConfig.growthSoulFarmland, 0.0, 1.0, (Component)Component.translatable((String)"config.avaritia.growth_soul_farmland.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.growthSoulFarmland).set(arg_0), (Supplier<Double>)ModConfig.growthSoulFarmland);
        this.addIntEntry("blade_slash_damage", ModConfig.bladeSlashDamage, 0, Integer.MAX_VALUE, (Component)Component.translatable((String)"config.avaritia.blade_slash_damage.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.bladeSlashDamage).set(arg_0), (Supplier<Integer>)ModConfig.bladeSlashDamage);
        this.addIntEntry("blade_slash_radius", ModConfig.bladeSlashRadius, 5, 100, (Component)Component.translatable((String)"config.avaritia.blade_slash_radius.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.bladeSlashRadius).set(arg_0), (Supplier<Integer>)ModConfig.bladeSlashRadius);
        this.addBooleanEntry("internal_infinity_catalyst_craft", ModConfig.internalInfinityCatalystCraft, (Component)Component.translatable((String)"config.avaritia.internal_infinity_catalyst_craft.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.internalInfinityCatalystCraft).set(arg_0), (Supplier<Boolean>)ModConfig.internalInfinityCatalystCraft);
        this.addCategoryHeader("config.avaritia.category.emc");
        this.addIntEntry("neutron_pile_emc", ModConfig.neutronPileEmc, 0, Integer.MAX_VALUE, (Component)Component.translatable((String)"config.avaritia.neutron_pile_emc.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.neutronPileEmc).set(arg_0), (Supplier<Integer>)ModConfig.neutronPileEmc);
        this.addIntEntry("vanilla_totem_emc", ModConfig.vanillaTotemEmc, 0, Integer.MAX_VALUE, (Component)Component.translatable((String)"config.avaritia.vanilla_totem_emc.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.vanillaTotemEmc).set(arg_0), (Supplier<Integer>)ModConfig.vanillaTotemEmc);
        this.addCategoryHeader("config.avaritia.category.storage");
        this.addIntEntry("chest_max_item_size", ModConfig.chestMaxItemSize, 2048, Integer.MAX_VALUE, (Component)Component.translatable((String)"config.avaritia.chest_max_item_size.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.chestMaxItemSize).set(arg_0), (Supplier<Integer>)ModConfig.chestMaxItemSize);
        this.addBooleanEntry("use_single_page_mode", ModConfig.useSinglePageMode, (Component)Component.translatable((String)"config.avaritia.use_single_page_mode.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.useSinglePageMode).set(arg_0), (Supplier<Boolean>)ModConfig.useSinglePageMode);
        this.addLongEntry("slot_stack_limit", ModConfig.slotStackLimit, 64L, 0xFFFFFFFFL, (Component)Component.translatable((String)"config.avaritia.slot_stack_limit.tooltip"), arg_0 -> ((ForgeConfigSpec.LongValue)ModConfig.slotStackLimit).set(arg_0), (Supplier<Long>)ModConfig.slotStackLimit);
        this.addIntEntry("max_page_limit", ModConfig.maxPageLimit, 2, 79536431, (Component)Component.translatable((String)"config.avaritia.max_page_limit.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.maxPageLimit).set(arg_0), (Supplier<Integer>)ModConfig.maxPageLimit);
        this.addIntEntry("reset_max_page", ModConfig.resetMaxPage, 1, 79536431, (Component)Component.translatable((String)"config.avaritia.reset_max_page.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.resetMaxPage).set(arg_0), (Supplier<Integer>)ModConfig.resetMaxPage);
        this.addIntEntry("inventory_rows", ModConfig.inventoryRows, 1, 6, (Component)Component.translatable((String)"config.avaritia.inventory_rows.tooltip"), arg_0 -> ((ForgeConfigSpec.IntValue)ModConfig.inventoryRows).set(arg_0), (Supplier<Integer>)ModConfig.inventoryRows);
        this.addCategoryHeader("config.avaritia.category.channel");
        this.addIntEntry("max_size_pre_channel", ModConfig.MAX_SIZE_PRE_CHANNEL, 2048, Integer.MAX_VALUE, (Component)Component.translatable((String)"config.avaritia.max_size_pre_channel.tooltip"), val -> ModConfig.MAX_SIZE_PRE_CHANNEL.set(val), (Supplier<Integer>)ModConfig.MAX_SIZE_PRE_CHANNEL);
        this.addIntEntry("max_channels_pre_player", ModConfig.MAX_CHANNELS_PRE_PLAYER, 4, 64, (Component)Component.translatable((String)"config.avaritia.max_channels_pre_player.tooltip"), val -> ModConfig.MAX_CHANNELS_PRE_PLAYER.set(val), (Supplier<Integer>)ModConfig.MAX_CHANNELS_PRE_PLAYER);
        this.addIntEntry("max_public_channels", ModConfig.MAX_PUBLIC_CHANNELS, 32, 1024, (Component)Component.translatable((String)"config.avaritia.max_public_channels.tooltip"), val -> ModConfig.MAX_PUBLIC_CHANNELS.set(val), (Supplier<Integer>)ModConfig.MAX_PUBLIC_CHANNELS);
        this.addIntEntry("channel_fast_update_rate", ModConfig.CHANNEL_FAST_UPDATE_RATE, 1, 40, (Component)Component.translatable((String)"config.avaritia.channel_fast_update_rate.tooltip"), val -> ModConfig.CHANNEL_FAST_UPDATE_RATE.set(val), (Supplier<Integer>)ModConfig.CHANNEL_FAST_UPDATE_RATE);
        this.addIntEntry("channel_full_update_rate", ModConfig.CHANNEL_FULL_UPDATE_RATE, 20, 1200, (Component)Component.translatable((String)"config.avaritia.channel_full_update_rate.tooltip"), val -> ModConfig.CHANNEL_FULL_UPDATE_RATE.set(val), (Supplier<Integer>)ModConfig.CHANNEL_FULL_UPDATE_RATE);
        this.addCategoryHeader("config.avaritia.category.misc");
        this.addBooleanEntry("use_advance_tooltips", ModConfig.useAdvanceTooltips, (Component)Component.translatable((String)"config.avaritia.use_advance_tooltips.tooltip"), arg_0 -> ((ForgeConfigSpec.BooleanValue)ModConfig.useAdvanceTooltips).set(arg_0), (Supplier<Boolean>)ModConfig.useAdvanceTooltips);
        this.addDoubleEntry("endless_item_entity_speed", ModConfig.immortalItemEntitySpeed, 1.0, 50.0, (Component)Component.translatable((String)"config.avaritia.endless_item_entity_speed.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.immortalItemEntitySpeed).set(arg_0), (Supplier<Double>)ModConfig.immortalItemEntitySpeed);
        this.addDoubleEntry("endless_item_entity_range", ModConfig.immortalItemEntityRange, 1.0, 10000.0, (Component)Component.translatable((String)"config.avaritia.endless_item_entity_range.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.immortalItemEntityRange).set(arg_0), (Supplier<Double>)ModConfig.immortalItemEntityRange);
        this.addDoubleEntry("infinity_elytra_flying_speed", ModConfig.infinityElytraFlyingSpeed, 1.0, 10.0, (Component)Component.translatable((String)"config.avaritia.infinity_elytra_flying_speed.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.infinityElytraFlyingSpeed).set(arg_0), (Supplier<Double>)ModConfig.infinityElytraFlyingSpeed);
        this.addDoubleEntry("boot_speed_base", ModConfig.bootSpeedBase, 0.01, 1.0, (Component)Component.translatable((String)"config.avaritia.boot_speed_base.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.bootSpeedBase).set(arg_0), (Supplier<Double>)ModConfig.bootSpeedBase);
        this.addDoubleEntry("boot_speed_flying_multiplier", ModConfig.bootSpeedFlyingMultiplier, 0.1, 5.0, (Component)Component.translatable((String)"config.avaritia.boot_speed_flying_multiplier.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.bootSpeedFlyingMultiplier).set(arg_0), (Supplier<Double>)ModConfig.bootSpeedFlyingMultiplier);
        this.addDoubleEntry("boot_speed_swimming_multiplier", ModConfig.bootSpeedSwimmingMultiplier, 0.1, 5.0, (Component)Component.translatable((String)"config.avaritia.boot_speed_swimming_multiplier.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.bootSpeedSwimmingMultiplier).set(arg_0), (Supplier<Double>)ModConfig.bootSpeedSwimmingMultiplier);
        this.addDoubleEntry("boot_speed_sneaking_multiplier", ModConfig.bootSpeedSneakingMultiplier, 0.01, 1.0, (Component)Component.translatable((String)"config.avaritia.boot_speed_sneaking_multiplier.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.bootSpeedSneakingMultiplier).set(arg_0), (Supplier<Double>)ModConfig.bootSpeedSneakingMultiplier);
        this.addDoubleEntry("boot_speed_backward_multiplier", ModConfig.bootSpeedBackwardMultiplier, 0.01, 1.0, (Component)Component.translatable((String)"config.avaritia.boot_speed_backward_multiplier.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.bootSpeedBackwardMultiplier).set(arg_0), (Supplier<Double>)ModConfig.bootSpeedBackwardMultiplier);
        this.addDoubleEntry("boot_speed_strafing_multiplier", ModConfig.bootSpeedStrafingMultiplier, 0.01, 1.0, (Component)Component.translatable((String)"config.avaritia.boot_speed_strafing_multiplier.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.bootSpeedStrafingMultiplier).set(arg_0), (Supplier<Double>)ModConfig.bootSpeedStrafingMultiplier);
        this.addDoubleEntry("boot_speed_sprinting_multiplier", ModConfig.bootSpeedSprintingMultiplier, 0.01, 1.0, (Component)Component.translatable((String)"config.avaritia.boot_speed_sprinting_multiplier.tooltip"), arg_0 -> ((ForgeConfigSpec.DoubleValue)ModConfig.bootSpeedSprintingMultiplier).set(arg_0), (Supplier<Double>)ModConfig.bootSpeedSprintingMultiplier);
    }

    private void addBooleanEntry(String titleKey, ForgeConfigSpec.BooleanValue configValue, Component description, Consumer<Boolean> onValueChange, Supplier<Boolean> valueSupplier) {
        this.configEntries.add(new BooleanConfigEntry((Component)Component.translatable((String)("config.avaritia." + titleKey)), description, (Boolean)configValue.get(), onValueChange, valueSupplier));
    }

    private void addIntEntry(String titleKey, ForgeConfigSpec.IntValue configValue, int min, int max, Component description, Consumer<Integer> onValueChange, Supplier<Integer> valueSupplier) {
        this.configEntries.add(new IntConfigEntry((Component)Component.translatable((String)("config.avaritia." + titleKey)), description, (Integer)configValue.get(), min, max, onValueChange, valueSupplier));
    }

    private void addDoubleEntry(String titleKey, ForgeConfigSpec.DoubleValue configValue, double min, double max, Component description, Consumer<Double> onValueChange, Supplier<Double> valueSupplier) {
        this.configEntries.add(new DoubleConfigEntry((Component)Component.translatable((String)("config.avaritia." + titleKey)), description, (Double)configValue.get(), min, max, onValueChange, valueSupplier));
    }

    private void addLongEntry(String titleKey, ForgeConfigSpec.LongValue configValue, long min, long max, Component description, Consumer<Long> onValueChange, Supplier<Long> valueSupplier) {
        this.configEntries.add(new LongConfigEntry((Component)Component.translatable((String)("config.avaritia." + titleKey)), description, (Long)configValue.get(), min, max, onValueChange, valueSupplier));
    }

    private void addCategoryHeader(String translationKey) {
        this.configEntries.add(new CategoryHeaderEntry((Component)Component.translatable((String)translationKey)));
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.resetButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"controls.reset"), btn -> {
            this.resetToDefaults();
            this.updateWidgetValues();
        }).bounds(this.width / 2 - 102, this.height - 30, 100, 20).build());
        this.backButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), btn -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 2, this.height - 30, 100, 20).build());
        for (int i = 0; i < this.configEntries.size(); ++i) {
            ConfigEntry<?> entry = this.configEntries.get(i);
            int x = 20;
            int y = 50 + i * 40 - this.scrollOffset;
            if (y + 40 <= 50 || y >= this.height - 40) continue;
            entry.initWidgets(this, x, y, this.width - 40);
        }
    }

    private void resetToDefaults() {
        ModConfig.isKeepStone.set((Object)((Boolean)ModConfig.isKeepStone.getDefault()));
        ModConfig.isMergeMatterCluster.set((Object)((Boolean)ModConfig.isMergeMatterCluster.getDefault()));
        ModConfig.swordRangeDamage.set((Object)((Integer)ModConfig.swordRangeDamage.getDefault()));
        ModConfig.swordAttackRange.set((Object)((Integer)ModConfig.swordAttackRange.getDefault()));
        ModConfig.isSwordAttackItemEntity.set((Object)((Boolean)ModConfig.isSwordAttackItemEntity.getDefault()));
        ModConfig.isSwordAttackLightning.set((Object)((Boolean)ModConfig.isSwordAttackLightning.getDefault()));
        ModConfig.isSwordAttackEndless.set((Object)((Boolean)ModConfig.isSwordAttackEndless.getDefault()));
        ModConfig.subArrowDamage.set((Object)((Integer)ModConfig.subArrowDamage.getDefault()));
        ModConfig.axeChainCount.set((Object)((Integer)ModConfig.axeChainCount.getDefault()));
        ModConfig.foodTime.set((Object)((Double)ModConfig.foodTime.getDefault()));
        ModConfig.pickAxeBreakRange.set((Object)((Integer)ModConfig.pickAxeBreakRange.getDefault()));
        ModConfig.shovelBreakRange.set((Object)((Integer)ModConfig.shovelBreakRange.getDefault()));
        ModConfig.neutronCollectorProductTick.set((Object)((Integer)ModConfig.neutronCollectorProductTick.getDefault()));
        ModConfig.singularityTimeRequired.set((Object)((Integer)ModConfig.singularityTimeRequired.getDefault()));
        ModConfig.growthSoulFarmland.set((Object)((Double)ModConfig.growthSoulFarmland.getDefault()));
        ModConfig.bladeSlashDamage.set((Object)((Integer)ModConfig.bladeSlashDamage.getDefault()));
        ModConfig.bladeSlashRadius.set((Object)((Integer)ModConfig.bladeSlashRadius.getDefault()));
        ModConfig.internalInfinityCatalystCraft.set((Object)((Boolean)ModConfig.internalInfinityCatalystCraft.getDefault()));
        ModConfig.neutronPileEmc.set((Object)((Integer)ModConfig.neutronPileEmc.getDefault()));
        ModConfig.vanillaTotemEmc.set((Object)((Integer)ModConfig.vanillaTotemEmc.getDefault()));
        ModConfig.chestMaxItemSize.set((Object)((Integer)ModConfig.chestMaxItemSize.getDefault()));
        ModConfig.useSinglePageMode.set((Object)((Boolean)ModConfig.useSinglePageMode.getDefault()));
        ModConfig.slotStackLimit.set((Object)((Long)ModConfig.slotStackLimit.getDefault()));
        ModConfig.maxPageLimit.set((Object)((Integer)ModConfig.maxPageLimit.getDefault()));
        ModConfig.resetMaxPage.set((Object)((Integer)ModConfig.resetMaxPage.getDefault()));
        ModConfig.inventoryRows.set((Object)((Integer)ModConfig.inventoryRows.getDefault()));
        ModConfig.MAX_SIZE_PRE_CHANNEL.set((Object)((Integer)ModConfig.MAX_SIZE_PRE_CHANNEL.getDefault()));
        ModConfig.MAX_CHANNELS_PRE_PLAYER.set((Object)((Integer)ModConfig.MAX_CHANNELS_PRE_PLAYER.getDefault()));
        ModConfig.MAX_PUBLIC_CHANNELS.set((Object)((Integer)ModConfig.MAX_PUBLIC_CHANNELS.getDefault()));
        ModConfig.CHANNEL_FAST_UPDATE_RATE.set((Object)((Integer)ModConfig.CHANNEL_FAST_UPDATE_RATE.getDefault()));
        ModConfig.CHANNEL_FULL_UPDATE_RATE.set((Object)((Integer)ModConfig.CHANNEL_FULL_UPDATE_RATE.getDefault()));
        ModConfig.useAdvanceTooltips.set((Object)((Boolean)ModConfig.useAdvanceTooltips.getDefault()));
        ModConfig.immortalItemEntitySpeed.set((Object)((Double)ModConfig.immortalItemEntitySpeed.getDefault()));
        ModConfig.immortalItemEntityRange.set((Object)((Double)ModConfig.immortalItemEntityRange.getDefault()));
        ModConfig.infinityElytraFlyingSpeed.set((Object)((Double)ModConfig.infinityElytraFlyingSpeed.getDefault()));
        ModConfig.bootSpeedSwimmingMultiplier.set((Object)((Double)ModConfig.bootSpeedSwimmingMultiplier.getDefault()));
        ModConfig.bootSpeedBackwardMultiplier.set((Object)((Double)ModConfig.bootSpeedBackwardMultiplier.getDefault()));
        ModConfig.bootSpeedSprintingMultiplier.set((Object)((Double)ModConfig.bootSpeedSprintingMultiplier.getDefault()));
        ModConfig.bootSpeedSneakingMultiplier.set((Object)((Double)ModConfig.bootSpeedSneakingMultiplier.getDefault()));
        ModConfig.bootSpeedStrafingMultiplier.set((Object)((Double)ModConfig.bootSpeedStrafingMultiplier.getDefault()));
        ModConfig.bootSpeedBase.set((Object)((Double)ModConfig.bootSpeedBase.getDefault()));
        ModConfig.bootSpeedFlyingMultiplier.set((Object)((Double)ModConfig.bootSpeedFlyingMultiplier.getDefault()));
    }

    private void updateWidgetValues() {
        for (ConfigEntry<?> entry : this.configEntries) {
            entry.updateWidgetValue();
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (Math.abs(this.scrollVelocity) > 0.1) {
            int maxOffset = Math.max(0, this.configEntries.size() * 40 - (this.height - 50 - 40));
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)maxOffset, (double)this.scrollOffset + this.scrollVelocity));
            this.scrollVelocity *= 0.92;
            if (Math.abs(this.scrollVelocity) < 0.1) {
                this.scrollVelocity = 0.0;
            }
            this.init();
        }
        this.renderBackground(guiGraphics);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        for (int i = 0; i < this.configEntries.size(); ++i) {
            ConfigEntry<?> entry = this.configEntries.get(i);
            int y = 50 + i * 40 - this.scrollOffset;
            if (y + 40 <= 30 || y >= this.height - 20) continue;
            entry.render(guiGraphics, mouseX, mouseY, 20, y, this.width - 40, 40, this.font);
        }
        if (this.configEntries.size() * 40 > this.height - 50 - 40) {
            int visibleHeight;
            this.maxScrollOffset = Math.max(0, this.configEntries.size() * 40 - (this.height - 50 - 40));
            this.scrollbarHeight = visibleHeight = this.height - 50 - 40;
            this.scrollbarHandleHeight = Math.max(20, visibleHeight * visibleHeight / (this.configEntries.size() * 40));
            int scrollBarYOffset = (int)((double)this.scrollOffset / (double)this.maxScrollOffset * (double)(visibleHeight - this.scrollbarHandleHeight));
            this.scrollbarY = 50 + scrollBarYOffset;
            this.scrollbarX = this.width - 8;
            guiGraphics.fill(this.scrollbarX, 50, this.scrollbarX + 4, 50 + this.scrollbarHeight, -2004318072);
            guiGraphics.fill(this.scrollbarX, this.scrollbarY, this.scrollbarX + 4, this.scrollbarY + this.scrollbarHandleHeight, -5592406);
        }
        this.resetButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.backButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        long currentTime = System.currentTimeMillis();
        double scrollDelta = -delta * 40.0 / 8.0;
        this.scrollVelocity = currentTime - this.lastScrollTime < 200L ? (this.scrollVelocity += scrollDelta * 0.5) : scrollDelta;
        this.lastScrollTime = currentTime;
        int maxOffset = Math.max(0, this.configEntries.size() * 40 - (this.height - 50 - 40));
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)maxOffset, (double)this.scrollOffset + scrollDelta));
        this.init();
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.configEntries.size() * 40 > this.height - 50 - 40) {
            if (mouseX >= (double)this.scrollbarX && mouseX <= (double)(this.scrollbarX + 4) && mouseY >= (double)this.scrollbarY && mouseY <= (double)(this.scrollbarY + this.scrollbarHandleHeight)) {
                this.isDraggingScrollbar = true;
                return true;
            }
            if (mouseX >= (double)this.scrollbarX && mouseX <= (double)(this.scrollbarX + 4) && mouseY >= 50.0 && mouseY <= (double)(50 + this.scrollbarHeight)) {
                int maxOffset = Math.max(0, this.configEntries.size() * 40 - (this.height - 50 - 40));
                double clickPosition = (mouseY - 50.0) / (double)this.scrollbarHeight;
                this.scrollOffset = (int)(clickPosition * (double)maxOffset);
                this.scrollOffset = Math.max(0, Math.min(maxOffset, this.scrollOffset));
                this.init();
                this.isDraggingScrollbar = true;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar && this.configEntries.size() * 40 > this.height - 50 - 40) {
            this.scrollVelocity = 0.0;
            int maxOffset = Math.max(0, this.configEntries.size() * 40 - (this.height - 50 - 40));
            double positionRatio = (mouseY - 50.0 - (double)this.scrollbarHandleHeight / 2.0) / (double)(this.scrollbarHeight - this.scrollbarHandleHeight);
            this.scrollOffset = (int)(positionRatio * (double)maxOffset);
            this.scrollOffset = Math.max(0, Math.min(maxOffset, this.scrollOffset));
            this.init();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private static class BooleanConfigEntry
    extends ConfigEntry<Boolean> {
        private Button checkBox;

        BooleanConfigEntry(Component title, Component description, Boolean initialValue, Consumer<Boolean> onValueChange, Supplier<Boolean> valueSupplier) {
            super(title, description, initialValue, onValueChange, valueSupplier);
        }

        @Override
        void initWidgets(AvaritiaConfigScreen screen, int x, int y, int width) {
            this.checkBox = Button.builder((Component)this.getButtonText(), btn -> {
                boolean newValue = (Boolean)this.currentValue == false;
                this.updateValue(newValue);
                btn.setMessage(this.getButtonText());
            }).bounds(x + width - 100, y + 10, 100, 20).build();
            screen.addRenderableWidget((GuiEventListener)this.checkBox);
        }

        @Override
        void render(GuiGraphics gui, int mouseX, int mouseY, int x, int y, int width, int height, Font font) {
            gui.drawString(font, this.title, x, y + 5, 0xFFFFFF);
            List wrappedDesc = font.split((FormattedText)this.description, width - 120);
            for (int i = 0; i < wrappedDesc.size(); ++i) {
                gui.drawString(font, (FormattedCharSequence)wrappedDesc.get(i), x, y + 20 + i * 10, 0xAAAAAA);
            }
        }

        private Component getButtonText() {
            return (Boolean)this.currentValue != false ? Component.translatable((String)"gui.yes") : Component.translatable((String)"gui.no");
        }

        @Override
        void updateWidgetValue() {
            if (this.checkBox != null) {
                this.currentValue = this.valueSupplier.get();
                this.checkBox.setMessage(this.getButtonText());
            }
        }
    }

    private static class IntConfigEntry
    extends ConfigEntry<Integer> {
        private RangedEditBox editBox;
        private final int min;
        private final int max;

        IntConfigEntry(Component title, Component description, Integer initialValue, int min, int max, Consumer<Integer> onValueChange, Supplier<Integer> valueSupplier) {
            super(title, description, initialValue, onValueChange, valueSupplier);
            this.min = min;
            this.max = max;
        }

        @Override
        void initWidgets(AvaritiaConfigScreen screen, int x, int y, int width) {
            this.editBox = new RangedEditBox(screen.font, x + width - 100, y + 10, 100, 20, (Component)Component.empty(), this.min, this.max, true);
            this.editBox.setMaxLength(10);
            this.editBox.setValue(String.valueOf(this.currentValue));
            this.editBox.setFilter(text -> {
                if (text.isEmpty()) {
                    return true;
                }
                try {
                    Integer.parseInt(text);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.editBox.setResponder(text -> {
                if (!text.isEmpty()) {
                    try {
                        this.updateValue(Integer.parseInt(text));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            screen.addRenderableWidget((GuiEventListener)this.editBox);
        }

        @Override
        void render(GuiGraphics gui, int mouseX, int mouseY, int x, int yPos, int width, int height, Font font) {
            gui.drawString(font, this.title, x, yPos + 5, 0xFFFFFF);
            List wrappedDesc = font.split((FormattedText)this.description, width - 120);
            for (int i = 0; i < wrappedDesc.size(); ++i) {
                gui.drawString(font, (FormattedCharSequence)wrappedDesc.get(i), x, yPos + 20 + i * 10, 0xAAAAAA);
            }
        }

        @Override
        void updateWidgetValue() {
            if (this.editBox != null) {
                this.currentValue = this.valueSupplier.get();
                this.editBox.setValue(String.valueOf(this.currentValue));
            }
        }
    }

    private static class DoubleConfigEntry
    extends ConfigEntry<Double> {
        private RangedEditBox editBox;
        private final double min;
        private final double max;

        DoubleConfigEntry(Component title, Component description, Double initialValue, double min, double max, Consumer<Double> onValueChange, Supplier<Double> valueSupplier) {
            super(title, description, initialValue, onValueChange, valueSupplier);
            this.min = min;
            this.max = max;
        }

        @Override
        void initWidgets(AvaritiaConfigScreen screen, int x, int y, int width) {
            this.editBox = new RangedEditBox(screen.font, x + width - 100, y + 10, 100, 20, (Component)Component.empty(), this.min, this.max, false);
            this.editBox.setMaxLength(10);
            this.editBox.setValue(String.valueOf(this.currentValue));
            this.editBox.setFilter(text -> {
                if (text.isEmpty()) {
                    return true;
                }
                if (text.contains(".") && text.indexOf(".") != text.lastIndexOf(".")) {
                    return false;
                }
                try {
                    Double.parseDouble(text);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.editBox.setResponder(text -> {
                if (!text.isEmpty()) {
                    try {
                        this.updateValue(Double.parseDouble(text));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            screen.addRenderableWidget((GuiEventListener)this.editBox);
        }

        @Override
        void render(GuiGraphics gui, int mouseX, int mouseY, int x, int yPos, int width, int height, Font font) {
            gui.drawString(font, this.title, x, yPos + 5, 0xFFFFFF);
            List wrappedDesc = font.split((FormattedText)this.description, width - 120);
            for (int i = 0; i < wrappedDesc.size(); ++i) {
                gui.drawString(font, (FormattedCharSequence)wrappedDesc.get(i), x, yPos + 20 + i * 10, 0xAAAAAA);
            }
        }

        @Override
        void updateWidgetValue() {
            if (this.editBox != null) {
                this.currentValue = this.valueSupplier.get();
                this.editBox.setValue(String.valueOf(this.currentValue));
            }
        }
    }

    private static class LongConfigEntry
    extends ConfigEntry<Long> {
        private RangedEditBox editBox;
        private final long min;
        private final long max;

        LongConfigEntry(Component title, Component description, Long initialValue, long min, long max, Consumer<Long> onValueChange, Supplier<Long> valueSupplier) {
            super(title, description, initialValue, onValueChange, valueSupplier);
            this.min = min;
            this.max = max;
        }

        @Override
        void initWidgets(AvaritiaConfigScreen screen, int x, int y, int width) {
            this.editBox = new RangedEditBox(screen.font, x + width - 100, y + 10, 100, 20, (Component)Component.empty(), this.min, this.max, false);
            this.editBox.setMaxLength(15);
            this.editBox.setValue(String.valueOf(this.currentValue));
            this.editBox.setFilter(text -> {
                if (text.isEmpty()) {
                    return true;
                }
                try {
                    Long.parseLong(text);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.editBox.setResponder(text -> {
                if (!text.isEmpty()) {
                    try {
                        this.updateValue(Long.parseLong(text));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            screen.addRenderableWidget((GuiEventListener)this.editBox);
        }

        @Override
        void render(GuiGraphics gui, int mouseX, int mouseY, int x, int yPos, int width, int height, Font font) {
            gui.drawString(font, this.title, x, yPos + 5, 0xFFFFFF);
            List wrappedDesc = font.split((FormattedText)this.description, width - 120);
            for (int i = 0; i < wrappedDesc.size(); ++i) {
                gui.drawString(font, (FormattedCharSequence)wrappedDesc.get(i), x, yPos + 20 + i * 10, 0xAAAAAA);
            }
        }

        @Override
        void updateWidgetValue() {
            if (this.editBox != null) {
                this.currentValue = this.valueSupplier.get();
                this.editBox.setValue(String.valueOf(this.currentValue));
            }
        }
    }

    private static class CategoryHeaderEntry
    extends ConfigEntry<Void> {
        CategoryHeaderEntry(Component title) {
            super(title, (Component)Component.empty(), null, null, null);
        }

        @Override
        void initWidgets(AvaritiaConfigScreen screen, int x, int y, int width) {
        }

        @Override
        void render(GuiGraphics gui, int mouseX, int mouseY, int x, int y, int width, int height, Font font) {
            gui.drawString(font, this.title, x, y + 5, 0xFFFFA0);
            gui.fill(x, y + 20, x + width, y + 22, -6250336);
        }

        @Override
        void updateWidgetValue() {
        }
    }

    private static abstract class ConfigEntry<T> {
        final Component title;
        final Component description;
        T currentValue;
        final Consumer<T> onValueChange;
        final Supplier<T> valueSupplier;

        ConfigEntry(Component title, Component description, T initialValue, Consumer<T> onValueChange, Supplier<T> valueSupplier) {
            this.title = title;
            this.description = description;
            this.currentValue = initialValue;
            this.onValueChange = onValueChange;
            this.valueSupplier = valueSupplier;
        }

        abstract void initWidgets(AvaritiaConfigScreen var1, int var2, int var3, int var4);

        abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, Font var8);

        abstract void updateWidgetValue();

        void updateValue(T newValue) {
            this.currentValue = newValue;
            if (this.onValueChange != null) {
                this.onValueChange.accept(newValue);
            }
        }
    }

    private static class RangedEditBox
    extends EditBox {
        private final double min;
        private final double max;
        private final boolean isInteger;
        private String lastValue = "";

        public RangedEditBox(Font font, int x, int y, int width, int height, Component component, double min, double max, boolean isInteger) {
            super(font, x, y, width, height, component);
            this.min = min;
            this.max = max;
            this.isInteger = isInteger;
        }

        public void tick() {
            super.tick();
            String currentValue = this.getValue();
            if (!currentValue.equals(this.lastValue)) {
                this.lastValue = currentValue;
            }
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            boolean result = super.keyPressed(keyCode, scanCode, modifiers);
            if (keyCode == 257 || keyCode == 335) {
                this.validateAndCorrectValue();
            }
            return result;
        }

        public void setFocused(boolean focused) {
            if (!focused && this.isFocused()) {
                this.validateAndCorrectValue();
            }
            super.setFocused(focused);
        }

        private void validateAndCorrectValue() {
            String text = this.getValue();
            if (!text.isEmpty()) {
                try {
                    if (this.isInteger) {
                        long val = Long.parseLong(text);
                        if ((double)val > this.max) {
                            this.setValue(String.valueOf((long)this.max));
                            this.moveCursorTo(0);
                        } else if ((double)val < this.min) {
                            this.setValue(String.valueOf((long)this.min));
                            this.moveCursorTo(0);
                        }
                    } else {
                        double val = Double.parseDouble(text);
                        if (val > this.max) {
                            this.setValue(String.valueOf(this.max));
                            this.moveCursorTo(0);
                        } else if (val < this.min) {
                            this.setValue(String.valueOf(this.min));
                            this.moveCursorTo(0);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

