/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.StringInputScreen;
import committee.nova.mods.avaritia.api.client.screen.component.SimpleScrollBar;
import committee.nova.mods.avaritia.api.client.screen.component.Text;
import committee.nova.mods.avaritia.common.menu.TesseractChannelMenu;
import committee.nova.mods.avaritia.common.net.channel.C2SAddChannelPack;
import committee.nova.mods.avaritia.common.net.channel.C2SRenameChannelPack;
import committee.nova.mods.avaritia.common.net.channel.C2SSetChannelPack;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class TesseractChannelScreen
extends AbstractContainerScreen<TesseractChannelMenu> {
    private int blitOffset;
    private static final ResourceLocation GUI_IMG = Res.BLACK_HOLE_CHANNEL_SELECT;
    private EditBox searchBox;
    private ChannelScrollBar scrollBar;
    private final ArrayList<int[]> filterChannels = new ArrayList();
    private int scrollAt = 0;
    private final ClientChannelManager channelManager = ClientChannelManager.getInstance();
    private boolean lShifting = false;
    private int lastMyChannelsCount = 0;
    private int lastOtherChannelsCount = 0;
    private int lastPublicChannelsCount = 0;

    public TesseractChannelScreen(TesseractChannelMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 88;
        this.imageHeight = 190;
        this.channelManager.addScreen(this);
    }

    public void blit(GuiGraphics pPoseStack, int pX, int pY, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        pPoseStack.blit(GUI_IMG, pX, pY, this.blitOffset, (float)pUOffset, (float)pVOffset, pUWidth, pVHeight, 256, 256);
    }

    @ParametersAreNonnullByDefault
    protected void renderLabels(GuiGraphics stack, int i, int j) {
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth + 4) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.scrollBar = new ChannelScrollBar(this.leftPos + 74, this.topPos + 8, 9, 90);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.addRenderableWidget((GuiEventListener)new AddChannelButton(this, this.leftPos + 7, this.topPos + 131));
        this.addRenderableWidget((GuiEventListener)new RenameButton(this, this.leftPos + 27, this.topPos + 131));
        this.addRenderableWidget((GuiEventListener)new DeleteButton(this.leftPos + 47, this.topPos + 131));
        this.addRenderableWidget((GuiEventListener)new BackButton(this.leftPos + 67, this.topPos + 131));
        this.searchBox = new EditBox(this.font, this.leftPos + 7, this.topPos + 118, 76, 12, (Component)Component.translatable((String)"gui.avaritia.search"));
        this.searchBox.setMaxLength(64);
        this.searchBox.setBordered(false);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        for (int i = 0; i < 9; ++i) {
            this.addRenderableWidget((GuiEventListener)new ChannelButton(this.leftPos + 7, this.topPos + 8 + i * 12, i));
        }
        this.updateChannelList();
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    protected void containerTick() {
        super.containerTick();
        this.searchBox.tick();
        if (this.channelManager.myChannels.size() != this.lastMyChannelsCount || this.channelManager.otherChannels.size() != this.lastOtherChannelsCount || this.channelManager.publicChannels.size() != this.lastPublicChannelsCount) {
            this.updateChannelList();
            this.lastMyChannelsCount = this.channelManager.myChannels.size();
            this.lastOtherChannelsCount = this.channelManager.otherChannels.size();
            this.lastPublicChannelsCount = this.channelManager.publicChannels.size();
        }
    }

    @ParametersAreNonnullByDefault
    protected void renderBg(GuiGraphics poseStack, float partialTick, int mouseX, int mouseY) {
        this.blit(poseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, 154);
    }

    public void updateChannelList() {
        this.filterChannels.clear();
        ArrayList temp = new ArrayList();
        this.channelManager.myChannels.forEach((integer, s) -> {
            if (s.contains(this.searchBox.getValue())) {
                temp.add(new int[]{0, integer});
            }
        });
        temp.sort((o1, o2) -> this.channelManager.myChannels.get(o1[1]).compareTo(this.channelManager.myChannels.get(o2[1])));
        this.filterChannels.addAll(temp);
        temp.clear();
        this.channelManager.otherChannels.forEach((integer, s) -> {
            if (s.contains(this.searchBox.getValue())) {
                temp.add(new int[]{1, integer});
            }
        });
        temp.sort((o1, o2) -> this.channelManager.otherChannels.get(o1[1]).compareTo(this.channelManager.otherChannels.get(o2[1])));
        this.filterChannels.addAll(temp);
        temp.clear();
        this.channelManager.publicChannels.forEach((integer, s) -> {
            if (s.contains(this.searchBox.getValue())) {
                temp.add(new int[]{2, integer});
            }
        });
        temp.sort((o1, o2) -> this.channelManager.publicChannels.get(o1[1]).compareTo(this.channelManager.publicChannels.get(o2[1])));
        this.filterChannels.addAll(temp);
        this.scrollBar.setScrollTagSize(10.0 / (double)this.filterChannels.size() * 182.0);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 1 && this.searchBox.isMouseOver(pMouseX, pMouseY)) {
            this.searchBox.setValue("");
            this.searchBox.setFocused(true);
            this.searchBox.setEditable(true);
            this.updateChannelList();
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrollBar.isScrolling()) {
            this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)(this.leftPos + 21) && pMouseX <= (double)(this.leftPos + 187) && pMouseY >= (double)(this.topPos + 7) && pMouseY <= (double)(this.topPos + 189)) {
            if (this.filterChannels.size() <= 10) {
                this.scrollAt = 0;
                this.scrollBar.setScrolledOn(0.0);
            } else {
                int a = pDelta <= 0.0 ? this.scrollAt + 1 : this.scrollAt - 1;
                this.scrollAt = Math.max(0, Math.min(this.filterChannels.size() - 10, a));
                this.scrollBar.setScrolledOn((double)this.scrollAt / (double)(this.filterChannels.size() - 10));
            }
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pDelta);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 340) {
            this.lShifting = true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchBox.isFocused()) {
            this.updateChannelList();
        }
        if (pKeyCode == 340) {
            this.lShifting = false;
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    @Generated
    public void setBlitOffset(int blitOffset) {
        this.blitOffset = blitOffset;
    }

    @Generated
    public int getBlitOffset() {
        return this.blitOffset;
    }

    private class ChannelScrollBar
    extends SimpleScrollBar {
        public ChannelScrollBar(int x, int y, int weight, int height) {
            super(x, y, weight, height);
        }

        @Override
        public void draggedTo(double scrolledOn) {
            TesseractChannelScreen.this.scrollAt = TesseractChannelScreen.this.filterChannels.size() <= 10 ? 0 : Math.round((float)(scrolledOn * (double)(TesseractChannelScreen.this.filterChannels.size() - 10)));
        }

        @Override
        public void beforeRender() {
        }
    }

    private class AddChannelButton
    extends ImageButton {
        public AddChannelButton(TesseractChannelScreen pScreen, int pX, int pY) {
            super(pX, pY, 18, 18, 202, 0, GUI_IMG, pButton -> Minecraft.getInstance().setScreen((Screen)new StringInputScreen((Screen)pScreen, Text.i18n("\u8bf7\u8f93\u5165\u9891\u9053\u540d\u79f0", new Object[0]).setShadow(true), Text.i18n("\u8bf7\u8f93\u5165", new Object[0]), "\\d{0,12}", "\u9ed8\u8ba4\u7684\u9891\u9053", input -> {
                if (!input.isEmpty()) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SAddChannelPack((String)input, committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this.lShifting));
                    pScreen.updateChannelList();
                }
            })));
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            float uOffset = this.isHoveredOrFocused() ? 220.0f : 202.0f;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), uOffset, 0.0f, this.width, this.height, 256, 256);
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"gui.avaritia.addChannel.tip2").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.addChannel.tip3").getVisualOrderText());
            if (this.isHovered) {
                TesseractChannelScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class RenameButton
    extends ImageButton {
        public RenameButton(TesseractChannelScreen pScreen, int pX, int pY) {
            super(pX, pY, 16, 16, 202, 34, GUI_IMG, pButton -> Minecraft.getInstance().setScreen((Screen)new StringInputScreen((Screen)pScreen, Text.i18n("\u8bf7\u8f93\u5165\u65b0\u7684\u9891\u9053\u540d\u79f0", new Object[0]).setShadow(true), Text.i18n("\u8bf7\u8f93\u5165", new Object[0]), "\\d{0,12}", "\u9ed8\u8ba4\u7684\u9891\u9053", input -> {
                if (!input.isEmpty()) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SRenameChannelPack(((TesseractChannelMenu)((TesseractChannelScreen)committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this).menu).containerId, (String)input));
                    pScreen.updateChannelList();
                }
            })));
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            float uOffset = this.isHoveredOrFocused() ? 218.0f : 202.0f;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), uOffset, 34.0f, this.width, this.height, 256, 256);
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            if (TesseractChannelScreen.this.channelManager.selectedChannelName.isEmpty()) {
                list.add(Component.translatable((String)"gui.avaritia.emptyChannel.tip4").getVisualOrderText());
            } else {
                String flag1 = "";
                boolean permissions = true;
                if (TesseractChannelScreen.this.channelManager.selectedChannelType == 0) {
                    flag1 = "\u00a7a";
                } else if (TesseractChannelScreen.this.channelManager.selectedChannelType != 2) {
                    flag1 = "\u00a7c";
                    permissions = false;
                }
                list.add(Component.translatable((String)"gui.avaritia.renameChannel.tip1", (Object[])new Object[]{flag1 + TesseractChannelScreen.this.channelManager.selectedChannelName}).getVisualOrderText());
                if (!permissions) {
                    list.add(Component.translatable((String)"gui.avaritia.noPermission.tip3").getVisualOrderText());
                }
            }
            if (this.isHovered) {
                TesseractChannelScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class DeleteButton
    extends ImageButton {
        public DeleteButton(int pX, int pY) {
            super(pX, pY, 16, 16, 202, 18, GUI_IMG, pButton -> ((TesseractChannelScreen)committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this).minecraft.gameMode.handleInventoryButtonClick(((TesseractChannelMenu)((TesseractChannelScreen)committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this).menu).containerId, 0));
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            float uOffset = this.isHoveredOrFocused() ? 218.0f : 202.0f;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), uOffset, 18.0f, this.width, this.height, 256, 256);
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            if (TesseractChannelScreen.this.channelManager.selectedChannelName.isEmpty()) {
                list.add(Component.translatable((String)"gui.avaritia.emptyChannel.tip4").getVisualOrderText());
            } else {
                String flag1 = "";
                boolean permissions = true;
                if (TesseractChannelScreen.this.channelManager.selectedChannelType == 0) {
                    flag1 = "\u00a7a";
                } else if (TesseractChannelScreen.this.channelManager.selectedChannelType != 2) {
                    flag1 = "\u00a7c";
                    permissions = false;
                }
                list.add(Component.translatable((String)"gui.avaritia.removeChannel.tip1", (Object[])new Object[]{flag1 + TesseractChannelScreen.this.channelManager.selectedChannelName}).getVisualOrderText());
                list.add(Component.translatable((String)"gui.avaritia.removeChannel.tip2").getVisualOrderText());
                if (!permissions) {
                    list.add(Component.translatable((String)"gui.avaritia.noPermission.tip3").getVisualOrderText());
                }
            }
            if (this.isHovered) {
                TesseractChannelScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class BackButton
    extends ImageButton {
        public BackButton(int pX, int pY) {
            super(pX, pY, 16, 16, 202, 50, GUI_IMG, pButton -> ((TesseractChannelScreen)committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this).minecraft.gameMode.handleInventoryButtonClick(((TesseractChannelMenu)((TesseractChannelScreen)committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this).menu).containerId, 1));
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            float uOffset = this.isHoveredOrFocused() ? 218.0f : 202.0f;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), uOffset, 50.0f, this.width, this.height, 256, 256);
            list.add(Component.translatable((String)"gui.avaritia.backChannel.tip1").getVisualOrderText());
            if (this.isHovered) {
                TesseractChannelScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class ChannelButton
    extends ImageButton {
        private final int buttonID;

        public ChannelButton(int pX, int pY, int id) {
            super(pX, pY, 64, 12, 0, 154, GUI_IMG, button -> {
                int[] a = committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this.filterChannels.get(id + committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this.scrollAt);
                NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SSetChannelPack(((TesseractChannelMenu)((TesseractChannelScreen)committee$nova$mods$avaritia$client$screen$TesseractChannelScreen$this).menu).containerId, (byte)a[0], a[1]));
            });
            this.buttonID = id;
        }

        @ParametersAreNonnullByDefault
        public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            this.visible = this.buttonID + TesseractChannelScreen.this.scrollAt < TesseractChannelScreen.this.filterChannels.size();
            super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }

        public void renderWidget(@NotNull GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            float vOffset;
            int[] a = TesseractChannelScreen.this.filterChannels.get(this.buttonID + TesseractChannelScreen.this.scrollAt);
            float f = vOffset = this.isHoveredOrFocused() ? 166.0f : 154.0f;
            if (a[0] == TesseractChannelScreen.this.channelManager.selectedChannelType && a[1] == TesseractChannelScreen.this.channelManager.selectedChannelID) {
                vOffset += 24.0f;
            }
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), 0.0f, vOffset, this.width, this.height, 256, 256);
            pPoseStack.drawString(TesseractChannelScreen.this.font, (String)(switch (a[0]) {
                case 0 -> "\u00a7a" + TesseractChannelScreen.this.channelManager.myChannels.get(a[1]);
                case 1 -> "\u00a7c" + TesseractChannelScreen.this.channelManager.otherChannels.get(a[1]);
                default -> TesseractChannelScreen.this.channelManager.publicChannels.get(a[1]);
            }), (float)this.getX() + 4.0f, (float)this.getY() + 4.0f, 0xFFFFFF, false);
        }
    }
}

