/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen.side;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.client.screen.side.SideConfigScreen;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

class SideButton
extends ImageButton {
    private final SideConfigScreen sideConfigScreen;
    private final Direction direction;
    private SideConfiguration.SideMode mode;
    private final List<FormattedCharSequence> tooltip;

    public SideButton(int x, int y, Direction direction, SideConfiguration.SideMode mode, SideConfigScreen sideConfigScreen) {
        super(x, y, 22, 23, 0, 118, 23, Res.SIDE_CONFIG_TEX, button -> {
            sideConfigScreen.cycleModeForDirection(direction);
            sideConfigScreen.updateAllButtons();
            sideConfigScreen.sendConfigUpdate();
        });
        this.sideConfigScreen = sideConfigScreen;
        this.direction = direction;
        this.mode = mode;
        this.tooltip = new ArrayList<FormattedCharSequence>();
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.tooltip.clear();
        String sideName = Component.translatable((String)("direction.avaritia." + this.direction.getName())).getString();
        String modeName = this.mode.getDisplayName().getString();
        this.tooltip.add(Component.literal((String)(sideName + ": " + modeName)).getVisualOrderText());
        this.tooltip.add(Component.translatable((String)"tooltip.avaritia.side.click_to_cycle").getVisualOrderText());
    }

    public void updateMode(SideConfiguration.SideMode newMode) {
        this.mode = newMode;
        this.updateTooltip();
    }

    public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int texY = 118;
        int texX = this.mode == SideConfiguration.SideMode.OFF ? 0 : (this.mode == SideConfiguration.SideMode.PASSIVE_OUTPUT || this.mode == SideConfiguration.SideMode.PASSIVE_MIXIN ? 22 : (this.mode == SideConfiguration.SideMode.ACTIVE_INPUT ? 44 : (this.mode == SideConfiguration.SideMode.ACTIVE_OUTPUT ? 66 : (this.mode == SideConfiguration.SideMode.ACTIVE_MIXIN ? 88 : 0))));
        if (this.isHovered) {
            texY += 23;
        }
        pGuiGraphics.blit(Res.SIDE_CONFIG_TEX, this.getX(), this.getY(), (float)texX, (float)texY, this.width, this.height, 256, 256);
        if (this.isHovered) {
            this.sideConfigScreen.setTooltipForNextRenderPass(this.tooltip);
        }
    }
}

