/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.chest;

import committee.nova.mods.avaritia.common.tile.CompressedChestTile;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressedChestBlock
extends ChestBlock {
    public CompressedChestBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava(), () -> (BlockEntityType)ModTileEntities.compressed_chest_tile.get());
    }

    public InteractionResult use(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult trace) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof CompressedChestTile) {
            CompressedChestTile chestTile = (CompressedChestTile)tile;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)chestTile, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new CompressedChestTile(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = pContext.getHorizontalDirection().getOpposite();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)TYPE, (Comparable)chesttype)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (pLevel.isClientSide()) {
            return;
        }
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (pStack.getTag() != null && blockentity instanceof CompressedChestTile) {
            CompressedChestTile chestTile = (CompressedChestTile)blockentity;
            chestTile.setChestTag(pStack.getTag());
        }
    }

    public void onPlace(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pMovedByPiston) {
        CompressedChestTile chestTile;
        if (pLevel.isClientSide()) {
            return;
        }
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        CompoundTag nameTag = null;
        CompoundTag countTag = null;
        CompoundTag nbtTag = null;
        if (blockentity instanceof CompressedChestTile && (chestTile = (CompressedChestTile)blockentity).getChestTag() != null) {
            CompoundTag chestTag = chestTile.getChestTag();
            if (chestTag.contains("name")) {
                nameTag = chestTag.getCompound("name");
            }
            if (chestTag.contains("count")) {
                countTag = chestTag.getCompound("count");
            }
            if (chestTag.contains("nbt")) {
                nbtTag = chestTag.getCompound("nbt");
            }
        }
        if (nameTag != null && countTag != null) {
            Container container = (Container)blockentity;
            for (String index : nameTag.getAllKeys()) {
                String name = nameTag.getString(index);
                Item newItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
                if (newItem == null) continue;
                ItemStack is = new ItemStack((ItemLike)newItem);
                is.setCount(countTag.getInt(index));
                if (nbtTag != null && !nbtTag.getCompound(index).isEmpty()) {
                    is.setTag(nbtTag.getCompound(index));
                }
                container.setItem(Integer.parseInt(index), is);
            }
        }
    }

    public void onRemove(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            CompoundTag chestTag = new CompoundTag();
            int stackCount = 0;
            if (blockentity instanceof Container) {
                Container container = (Container)blockentity;
                CompoundTag nameTag = new CompoundTag();
                CompoundTag countTag = new CompoundTag();
                CompoundTag nbtTag = new CompoundTag();
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    ItemStack item = container.getItem(i);
                    if (item.isEmpty()) continue;
                    ++stackCount;
                    nameTag.putString(String.valueOf(i), ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)item.getItem()).get()).location().toString());
                    countTag.putInt(String.valueOf(i), item.getCount());
                    if (item.getTag() == null) continue;
                    nbtTag.put(String.valueOf(i), (Tag)item.getTag());
                }
                chestTag.put("name", (Tag)nameTag);
                chestTag.put("count", (Tag)countTag);
                chestTag.put("nbt", (Tag)nbtTag);
                chestTag.putInt("stackCount", stackCount);
            }
            if (blockentity instanceof CompressedChestTile) {
                CompressedChestTile chestTile = (CompressedChestTile)blockentity;
                chestTile.setChestTag(chestTag);
            }
            pLevel.removeBlockEntity(pPos);
        }
    }

    public void playerDestroy(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            ItemStack pStack = new ItemStack((ItemLike)((Block)ModBlocks.compressed_chest.get()).asItem());
            if (pBlockEntity instanceof CompressedChestTile) {
                CompressedChestTile chestTile = (CompressedChestTile)pBlockEntity;
                pStack.setTag(chestTile.getChestTag());
            }
            CompressedChestBlock.popResource((Level)serverLevel, (BlockPos)pPos, (ItemStack)pStack);
            pState.spawnAfterBreak(serverLevel, pPos, pTool, false);
        }
    }

    public void appendHoverText(ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        int stackCount = 0;
        if (pStack.getTag() != null && pStack.getTag().contains("stackCount")) {
            stackCount = pStack.getTag().getInt("stackCount");
        }
        pTooltip.add((Component)Component.literal((String)String.format("%s/243", stackCount)));
    }
}

