/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.chest;

import com.google.common.collect.ImmutableMap;
import committee.nova.mods.avaritia.api.common.block.BaseTileEntityBlock;
import committee.nova.mods.avaritia.common.menu.provider.ChannelMenuProvider;
import committee.nova.mods.avaritia.common.tile.TesseractTile;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TesseractBlock
extends BaseTileEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;

    public TesseractBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).instrument(NoteBlockInstrument.BASS).strength(30.0f, 1200.0f).sound(SoundType.GLASS).lightLevel(TesseractBlock::getLightLevel).isValidSpawn((state, getter, pos, entityType) -> false).isSuffocating((state, getter, pos) -> false).ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.TRUE)).setValue((Property)SOUTH, (Comparable)Boolean.TRUE)).setValue((Property)WEST, (Comparable)Boolean.TRUE)).setValue((Property)EAST, (Comparable)Boolean.TRUE)).setValue((Property)UP, (Comparable)Boolean.TRUE)).setValue((Property)DOWN, (Comparable)Boolean.TRUE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.shapesCache = this.getShapeForEachState(TesseractBlock::calculateShape);
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0), Block.box((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0, (double)13.0), Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.box((double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), Block.box((double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0), Block.box((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), Block.box((double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), Block.box((double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0)});
        if (!((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0));
        }
        if (!((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
        }
        if (!((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0));
        }
        if (!((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)Block.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        }
        if (!((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0));
        }
        if (!((Boolean)state.getValue((Property)UP)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        }
        return voxelshape;
    }

    private static int getLightLevel(BlockState value) {
        if (((Boolean)value.getValue((Property)NORTH)).booleanValue() || ((Boolean)value.getValue((Property)SOUTH)).booleanValue() || ((Boolean)value.getValue((Property)WEST)).booleanValue() || ((Boolean)value.getValue((Property)EAST)).booleanValue() || ((Boolean)value.getValue((Property)DOWN)).booleanValue() || ((Boolean)value.getValue((Property)UP)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN, WATERLOGGED});
    }

    public void appendHoverText(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        CompoundTag nbt;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (!pStack.hasTag()) {
            return;
        }
        if (pStack.getTag().contains("BlockEntityTag") && (nbt = pStack.getTag().getCompound("BlockEntityTag")).contains("owner")) {
            UUID selfUUID = Minecraft.getInstance().player.getUUID();
            UUID ownerUUID = nbt.getUUID("owner");
            String ownerName = ClientChannelManager.getInstance().getUserName(nbt.getUUID("owner"));
            boolean lock = nbt.getBoolean("locked");
            if (selfUUID.equals(ownerUUID)) {
                pTooltip.add((Component)Component.translatable((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7a" + ownerName}));
            } else if (lock) {
                pTooltip.add((Component)Component.translatable((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7c" + ownerName}));
            } else {
                pTooltip.add((Component)Component.translatable((String)"gui.avaritia.owner", (Object[])new Object[]{ownerName}));
            }
        }
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult trace) {
        BlockEntity tile;
        if (!level.isClientSide() && !player.isSpectator() && (tile = level.getBlockEntity(pos)) instanceof TesseractTile) {
            TesseractTile chestTile = (TesseractTile)tile;
            if (chestTile.getOwner() == null) {
                chestTile.setOwner(player.getUUID());
                chestTile.setLocked(false);
            }
            if (chestTile.getChannelOwner() == null || chestTile.getChannelID() < 0) {
                chestTile.setChannelOwner(player.getUUID());
                chestTile.setChannelId(0);
            }
            if (chestTile.getChannelInfo() == null) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ChannelMenuProvider(chestTile), buf -> {});
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ChannelMenuProvider(chestTile), buf -> {
                    buf.writeBlockPos(pos);
                    buf.writeInt(-2);
                    buf.writeUUID(chestTile.getOwner());
                    buf.writeBoolean(chestTile.isLocked());
                    buf.writeBoolean(chestTile.isCraftingMode());
                    buf.writeUtf(chestTile.getFilter(), 64);
                    buf.writeByte((int)chestTile.getSortType());
                    buf.writeByte((int)chestTile.getViewType());
                    buf.writeUUID(chestTile.getChannelOwner());
                    buf.writeInt(chestTile.getChannelID());
                });
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        BlockPos blockpos = placeContext.getClickedPos();
        FluidState fluidstate = placeContext.getLevel().getFluidState(blockpos);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new TesseractTile(pPos, pState);
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        if (pPlacer instanceof ServerPlayer) {
            TesseractTile blockEntity;
            ServerPlayer player = (ServerPlayer)pPlacer;
            if (!pStack.getOrCreateTag().contains("BlockEntityTag") && (blockEntity = (TesseractTile)pLevel.getBlockEntity(pPos)) != null) {
                blockEntity.setOwner(pPlacer.getUUID());
            }
        }
    }

    public void entityInside(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (pLevel.isClientSide) {
            return;
        }
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof TesseractTile) {
            TesseractTile tesseractTile = (TesseractTile)blockentity;
            if (pEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)pEntity;
                tesseractTile.inhaleItem(itemEntity);
            }
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.block();
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape = (VoxelShape)this.shapesCache.get((Object)pState);
        if (shape != null) {
            return shape;
        }
        return Shapes.block();
    }

    @NotNull
    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        VoxelShape shape = (VoxelShape)this.shapesCache.get((Object)pState);
        if (shape != null) {
            return shape;
        }
        return Shapes.block();
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState pState) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    @NotNull
    public BlockState updateShape(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        TesseractTile blockEntity = (TesseractTile)level.getBlockEntity(pos);
        if (blockEntity != null) {
            blockEntity.onBlockStateChange();
        }
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }
}

