/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.container.slot;

import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ModCraftResultSlot
extends Slot {
    private final AbstractContainerMenu container;
    private final CraftingContainer craftSlots;
    private final Player player;
    private int removeCount;

    public ModCraftResultSlot(Player pPlayer, AbstractContainerMenu menu, CraftingContainer craftSlots, Container container, int index, int xPosition, int yPosition) {
        super(container, index, xPosition, yPosition);
        this.player = pPlayer;
        this.container = menu;
        this.craftSlots = craftSlots;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack remove(int pAmount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(pAmount, this.getItem().getCount());
        }
        return super.remove(pAmount);
    }

    protected void onQuickCraft(@NotNull ItemStack pStack, int pAmount) {
        this.removeCount += pAmount;
        this.checkTakeAchievements(pStack);
    }

    protected void onSwapCraft(int pNumItemsCrafted) {
        this.removeCount += pNumItemsCrafted;
    }

    public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
        this.checkTakeAchievements(stack);
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList remaining = player.level().getRecipeManager().getRemainingItemsFor((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), (Container)this.craftSlots, player.level());
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack slotStack = this.craftSlots.getItem(i);
            ItemStack remainingStack = (ItemStack)remaining.get(i);
            if (!slotStack.isEmpty()) {
                this.craftSlots.removeItem(i, 1);
                slotStack = this.craftSlots.getItem(i);
            }
            if (remainingStack.isEmpty()) continue;
            if (slotStack.isEmpty()) {
                this.craftSlots.setItem(i, remainingStack);
                continue;
            }
            if (ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)remainingStack) && ItemStack.isSameItemSameTags((ItemStack)slotStack, (ItemStack)remainingStack)) {
                remainingStack.grow(slotStack.getCount());
                this.craftSlots.setItem(i, remainingStack);
                continue;
            }
            if (this.player.getInventory().add(remainingStack)) continue;
            this.player.drop(remainingStack, false);
        }
        this.container.slotsChanged((Container)this.craftSlots);
    }

    protected void checkTakeAchievements(@NotNull ItemStack pStack) {
        AbstractContainerMenu abstractContainerMenu;
        if (this.removeCount > 0) {
            pStack.onCraftedBy(this.player.level(), this.player, this.removeCount);
            ForgeEventFactory.firePlayerCraftingEvent((Player)this.player, (ItemStack)pStack, (Container)this.craftSlots);
        }
        if ((abstractContainerMenu = this.container) instanceof RecipeHolder) {
            RecipeHolder recipeholder = (RecipeHolder)abstractContainerMenu;
            recipeholder.awardUsedRecipes(this.player, this.craftSlots.getItems());
        }
        this.removeCount = 0;
    }
}

