/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.crafting.ISpecialRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CompressorRecipe
implements ISpecialRecipe,
ICompressorRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int inputCount;
    private final int timeCost;

    public CompressorRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output, int inputCount, int timeCost) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{input});
        this.output = output;
        this.inputCount = inputCount;
        this.timeCost = timeCost;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess pRegistryAccess) {
        return this.output;
    }

    @NotNull
    public ItemStack getResultItem() {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipeId;
    }

    @Override
    public int getTimeCost() {
        return this.timeCost;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.COMPRESSOR_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get();
    }

    @Override
    public ItemStack assemble(IItemHandler inventory) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull Container inv, @NotNull RegistryAccess p_267052_) {
        return this.output.copy();
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        ItemStack input = inventory.getStackInSlot(0);
        return ((Ingredient)this.inputs.get(0)).test(input);
    }

    @Override
    public boolean matches(@NotNull Container inv, @NotNull Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public static class Serializer
    implements RecipeSerializer<CompressorRecipe> {
        @NotNull
        public CompressorRecipe fromJson(@NotNull ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.fromJson((JsonElement)json.getAsJsonObject("ingredient"));
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            int inputCount = GsonHelper.getAsInt((JsonObject)json, (String)"inputCount", (int)1000);
            int timeCost = GsonHelper.getAsInt((JsonObject)json, (String)"timeCost");
            return new CompressorRecipe(recipeId, input, output, inputCount, timeCost);
        }

        public CompressorRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            ItemStack output = buffer.readItem();
            int inputCount = buffer.readInt();
            int timeCost = buffer.readInt();
            return new CompressorRecipe(recipeId, input, output, inputCount, timeCost);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, CompressorRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).toNetwork(buffer);
            buffer.writeItem(recipe.output);
            buffer.writeInt(recipe.inputCount);
            buffer.writeInt(recipe.timeCost);
        }
    }
}

