/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityReloadListener;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.util.SingularityUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EternalSingularityCraftRecipe
extends ShapelessTableCraftingRecipe {
    public static Object2BooleanOpenHashMap<EternalSingularityCraftRecipe> INGREDIENTS_LOADED = new Object2BooleanOpenHashMap();
    public final NonNullList<Ingredient> inputs;

    public EternalSingularityCraftRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs) {
        super(recipeId, (NonNullList<Ingredient>)NonNullList.create(), new ItemStack((ItemLike)ModItems.eternal_singularity.get()), 4);
        this.inputs = inputs;
    }

    @Override
    public boolean matches(@NotNull Container input, @NotNull Level level) {
        NonNullList<Ingredient> ingredients = this.getIngredients();
        if (ingredients.isEmpty()) {
            return false;
        }
        int singularityCount = SingularityReloadListener.INSTANCE.getAllSingularities().values().stream().filter(singularity -> singularity.getIngredient() != Ingredient.EMPTY).mapToInt(singularity -> 1).sum();
        boolean[] found = new boolean[singularityCount];
        int validItems = 0;
        for (int i = 0; i < input.getContainerSize(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++validItems;
            boolean matched = false;
            int index = 0;
            for (Singularity singularity2 : SingularityReloadListener.INSTANCE.getAllSingularities().values()) {
                if (singularity2.getIngredient() == Ingredient.EMPTY) continue;
                ItemStack singularityStack = SingularityUtils.getItemForSingularity(singularity2);
                if (ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)singularityStack) && !found[index]) {
                    found[index] = true;
                    matched = true;
                    break;
                }
                ++index;
            }
            if (matched) continue;
            return false;
        }
        for (boolean b : found) {
            if (b) continue;
            return false;
        }
        return validItems == singularityCount;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        if (!INGREDIENTS_LOADED.getOrDefault((Object)this, false)) {
            super.getIngredients().clear();
            if (!this.inputs.isEmpty()) {
                super.getIngredients().addAll(this.inputs);
            } else {
                SingularityReloadListener.INSTANCE.getAllSingularities().values().stream().filter(singularity -> singularity.getIngredient() != Ingredient.EMPTY).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> super.getIngredients().add(arg_0));
            }
            INGREDIENTS_LOADED.put((Object)this, true);
        }
        return super.getIngredients();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.ETERNAL_SINGULARITY_CRAFT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<EternalSingularityCraftRecipe> {
        @NotNull
        public EternalSingularityCraftRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            NonNullList inputs = NonNullList.create();
            JsonArray ingredients = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.fromJson((JsonElement)ingredients.get(i)));
            }
            return new EternalSingularityCraftRecipe(recipeId, (NonNullList<Ingredient>)inputs);
        }

        public EternalSingularityCraftRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            return new EternalSingularityCraftRecipe(recipeId, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull EternalSingularityCraftRecipe recipe) {
            buffer.writeVarInt(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.toNetwork(buffer);
            }
        }
    }
}

