/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class ExtremeSmithingRecipe
implements SmithingRecipe {
    private final ResourceLocation id;
    public final Ingredient template;
    public final Ingredient base;
    public final Ingredient additions;
    public final ItemStack result;

    public ExtremeSmithingRecipe(ResourceLocation pId, Ingredient pTemplate, Ingredient pBase, Ingredient additions, ItemStack pResult) {
        this.id = pId;
        this.template = pTemplate;
        this.base = pBase;
        this.additions = additions;
        this.result = pResult;
    }

    public boolean matches(Container pContainer, @NotNull Level pLevel) {
        return this.template.test(pContainer.getItem(0)) && this.base.test(pContainer.getItem(1)) && this.additions.test(pContainer.getItem(2)) && this.additions.test(pContainer.getItem(3)) && this.additions.test(pContainer.getItem(4));
    }

    @NotNull
    public ItemStack assemble(Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        ItemStack itemstack = this.result.copy();
        CompoundTag compoundtag = pContainer.getItem(1).getTag();
        if (compoundtag != null) {
            itemstack.setTag(compoundtag.copy());
        }
        return itemstack;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public boolean isTemplateIngredient(@NotNull ItemStack pStack) {
        return this.template.test(pStack);
    }

    public boolean isBaseIngredient(@NotNull ItemStack pStack) {
        return this.base.test(pStack);
    }

    public boolean isAdditionIngredient(@NotNull ItemStack pStack) {
        return this.additions.test(pStack);
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.EXTREME_SMITHING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.EXTREME_SMITHING_RECIPE.get();
    }

    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.additions).anyMatch(ForgeHooks::hasNoElements);
    }

    public static class Serializer
    implements RecipeSerializer<ExtremeSmithingRecipe> {
        @NotNull
        public ExtremeSmithingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            Ingredient ingredient = Ingredient.fromJson((JsonElement)GsonHelper.getNonNull((JsonObject)pSerializedRecipe, (String)"template"));
            Ingredient ingredient1 = Ingredient.fromJson((JsonElement)GsonHelper.getNonNull((JsonObject)pSerializedRecipe, (String)"base"));
            Ingredient ingredient2 = Ingredient.fromJson((JsonElement)GsonHelper.getNonNull((JsonObject)pSerializedRecipe, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)pSerializedRecipe, (String)"result"));
            return new ExtremeSmithingRecipe(pRecipeId, ingredient, ingredient1, ingredient2, itemstack);
        }

        public ExtremeSmithingRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            Ingredient ingredient1 = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            Ingredient ingredient2 = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.readItem();
            return new ExtremeSmithingRecipe(pRecipeId, ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, ExtremeSmithingRecipe pRecipe) {
            pRecipe.template.toNetwork(pBuffer);
            pRecipe.base.toNetwork(pBuffer);
            pRecipe.additions.toNetwork(pBuffer);
            pBuffer.writeItem(pRecipe.result);
        }
    }
}

