/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityReloadListener;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.util.SingularityUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

public class InfinityCatalystCraftRecipe
extends ShapelessTableCraftingRecipe {
    public static Object2BooleanOpenHashMap<InfinityCatalystCraftRecipe> INGREDIENTS_LOADED = new Object2BooleanOpenHashMap();
    private final String group;
    private final int count;
    private final NonNullList<Ingredient> originalInputs;

    public InfinityCatalystCraftRecipe(ResourceLocation recipeId, String pGroup, NonNullList<Ingredient> inputs, int count) {
        super(recipeId, (NonNullList<Ingredient>)NonNullList.create(), new ItemStack((ItemLike)ModItems.infinity_catalyst.get(), count), 4);
        this.group = pGroup;
        this.count = count;
        this.originalInputs = inputs;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        if (!INGREDIENTS_LOADED.getOrDefault((Object)this, false)) {
            super.getIngredients().clear();
            super.getIngredients().addAll(this.originalInputs);
            if ("default".equals(this.group)) {
                SingularityReloadListener.INSTANCE.getAllSingularities().values().stream().filter(singularity -> singularity.getIngredient() != Ingredient.EMPTY).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> super.getIngredients().add(arg_0));
            }
            INGREDIENTS_LOADED.put((Object)this, true);
        }
        return super.getIngredients();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @Override
    public boolean matches(@NotNull Container input, @NotNull Level level) {
        if ("default".equals(this.group)) {
            return this.matchesSingularityRecipe(input);
        }
        return this.matchesStandardRecipe(input);
    }

    private boolean matchesSingularityRecipe(@NotNull Container input) {
        NonNullList<Ingredient> ingredients = this.getIngredients();
        if (ingredients.isEmpty()) {
            return false;
        }
        Map<ResourceLocation, Singularity> singularities = SingularityReloadListener.INSTANCE.getAllSingularities();
        if (singularities == null || singularities.isEmpty()) {
            return false;
        }
        int singularityCount = singularities.values().stream().filter(singularity -> singularity.getIngredient() != Ingredient.EMPTY).mapToInt(singularity -> 1).sum();
        if (singularityCount == 0) {
            return false;
        }
        boolean[] found = new boolean[singularityCount];
        int validItems = 0;
        for (int i = 0; i < input.getContainerSize(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++validItems;
            boolean matched = false;
            int index = 0;
            for (Singularity singularity2 : singularities.values()) {
                if (singularity2.getIngredient() == Ingredient.EMPTY) continue;
                ItemStack singularityStack = SingularityUtils.getItemForSingularity(singularity2);
                if (ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)singularityStack) && !found[index]) {
                    found[index] = true;
                    matched = true;
                    break;
                }
                ++index;
            }
            if (matched) continue;
            return false;
        }
        for (boolean b : found) {
            if (b) continue;
            return false;
        }
        return validItems == singularityCount;
    }

    private boolean matchesStandardRecipe(@NotNull Container input) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < input.getContainerSize(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            inputs.add(stack);
            ++matched;
        }
        return matched == this.originalInputs.size() && RecipeMatcher.findMatches(inputs, this.originalInputs) != null;
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.INFINITY_CATALYST_CRAFT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<InfinityCatalystCraftRecipe> {
        @NotNull
        public InfinityCatalystCraftRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group1 = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"default");
            NonNullList inputs = NonNullList.create();
            JsonArray ingredients = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.fromJson((JsonElement)ingredients.get(i)));
            }
            int count = GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1);
            return new InfinityCatalystCraftRecipe(recipeId, group1, (NonNullList<Ingredient>)inputs, count);
        }

        public InfinityCatalystCraftRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            int count = buffer.readInt();
            return new InfinityCatalystCraftRecipe(recipeId, group, (NonNullList<Ingredient>)inputs, count);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull InfinityCatalystCraftRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeVarInt(recipe.originalInputs.size());
            for (Ingredient ingredient : recipe.originalInputs) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeInt(recipe.count);
        }
    }
}

