/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class StormProEntity
extends ThrowableItemProjectile {
    public StormProEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected Item getDefaultItem() {
        return Items.FIRE_CHARGE;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            LightningBolt lightning;
            BlockPos pos = null;
            if (result instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)result;
                pos = blockHit.getBlockPos().relative(blockHit.getDirection());
            } else if (result instanceof EntityHitResult) {
                EntityHitResult entityHit = (EntityHitResult)result;
                pos = entityHit.getEntity().blockPosition();
            }
            if (pos != null && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level())) != null) {
                lightning.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                Entity entity = this.getOwner();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    lightning.setCause(player);
                }
                this.level().addFreshEntity((Entity)lightning);
            }
            this.discard();
        }
    }
}

