/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity.arrow;

import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class ExplosionsArrowEntity
extends Arrow {
    public ExplosionsArrowEntity(EntityType<? extends Arrow> entityType, Level level) {
        super(entityType, level);
    }

    public ExplosionsArrowEntity(Level world, Entity pShooter, double xPos, double yPos, double zPos) {
        this((EntityType<? extends Arrow>)((EntityType)ModEntities.EXPLOSIONS_ARROW.get()), world);
        this.setOwner(pShooter);
        this.setPos(xPos, yPos, zPos);
    }

    public ExplosionsArrowEntity(Level world, Entity pShooter) {
        this(world, pShooter, pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        if (pShooter instanceof Player) {
            this.pickup = AbstractArrow.Pickup.DISALLOWED;
        }
    }

    public ExplosionsArrowEntity(Entity pShooter) {
        this(pShooter.level(), pShooter);
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        if (this.getOwner() != null) {
            this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 8.0f, Level.ExplosionInteraction.MOB);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level().getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)pos.getCenter(), (double)10.0, (double)10.0, (double)10.0), entityx -> !entityx.isSpectator()).forEach(entityx -> entityx.addEffect(new MobEffectInstance((MobEffect)ModMobEffects.BURNING.get(), -1)));
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity = result.getEntity();
        float HEAVEN_ARROW_DAMAGE = 100.0f;
        if (this.getOwner() != null) {
            if (entity == this.getOwner()) {
                return;
            }
            entity.hurt(ModDamageTypes.causeRandomDamage(this.level(), this.getOwner()), 100.0f);
            this.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(10.0, 10.0, 10.0), entityx -> !entityx.isSpectator()).forEach(entityx -> entityx.addEffect(new MobEffectInstance((MobEffect)ModMobEffects.BURNING.get(), -1)));
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    protected float getWaterInertia() {
        return 1.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

