/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.common.tile.NeutronCollectorTile;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.enums.CollectorTier;
import committee.nova.mods.avaritia.init.registry.enums.CompressorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class InfinityUpgradeItem
extends ResourceItem {
    public InfinityUpgradeItem() {
        super(ModRarities.LEGEND, true, new Item.Properties().durability(16));
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isValidRepairItem(@NotNull ItemStack pStack, @NotNull ItemStack pRepairCandidate) {
        return pRepairCandidate.is((Item)ModItems.star_fuel.get());
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        ServerPlayer serverPlayer;
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockEntity tile = pContext.getLevel().getBlockEntity(pContext.getClickedPos());
        Player player = pContext.getPlayer();
        ItemStack itemInHand = pContext.getItemInHand();
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).isShiftKeyDown()) {
            if (tile instanceof NeutronCollectorTile) {
                NeutronCollectorTile collectorTile = (NeutronCollectorTile)tile;
                switch (collectorTile.getTier()) {
                    case DEFAULT: {
                        collectorTile.setTier(CollectorTier.DENSE);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.dense_neutron_collector.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.hurt(1, serverPlayer.getRandom(), serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                    case DENSE: {
                        collectorTile.setTier(CollectorTier.DENSER);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.denser_neutron_collector.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.hurt(1, serverPlayer.getRandom(), serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                    case DENSER: {
                        collectorTile.setTier(CollectorTier.DENSEST);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.densest_neutron_collector.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.hurt(4, serverPlayer.getRandom(), serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.PASS;
            }
            if (tile instanceof NeutronCompressorTile) {
                NeutronCompressorTile compressorTile = (NeutronCompressorTile)tile;
                switch (compressorTile.getTier()) {
                    case DEFAULT: {
                        compressorTile.setTier(CompressorTier.DENSE);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.dense_neutron_compressor.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.hurt(1, serverPlayer.getRandom(), serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                    case DENSE: {
                        compressorTile.setTier(CompressorTier.DENSER);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.denser_neutron_compressor.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.hurt(1, serverPlayer.getRandom(), serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                    case DENSER: {
                        compressorTile.setTier(CompressorTier.DENSEST);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.densest_neutron_compressor.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.hurt(4, serverPlayer.getRandom(), serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.PASS;
            }
            return super.useOn(pContext);
        }
        return super.useOn(pContext);
    }
}

