/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.blaze;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.common.entity.arrow.BurningArrowEntity;
import committee.nova.mods.avaritia.common.entity.ball.BurningBallEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazeBowItem
extends BowItem
implements ITooltip,
ISwitchable,
IBowTransform {
    public BlazeBowItem() {
        super(new Item.Properties().stacksTo(1).rarity(ModRarities.EPIC).fireResistant());
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    @Override
    public boolean hasDescTooltip() {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        if (player.isShiftKeyDown()) {
            this.switchMode(level, player, hand, "blaze_bow_burning");
            return InteractionResultHolder.success((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)itemstack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int drawTime = this.getUseDuration(stack) - timeLeft;
            if ((drawTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (boolean)true)) < 0) {
                return;
            }
            float VELOCITY_MULTIPLIER = 1.2f;
            float DAMAGE_MULTIPLIER = 2.0f;
            float draw = BlazeBowItem.getPowerForTime((int)drawTime);
            float powerForTime = draw * VELOCITY_MULTIPLIER;
            if ((double)powerForTime >= 0.1) {
                if (!level.isClientSide) {
                    if (this.isActive(stack, "blaze_bow_burning")) {
                        BurningBallEntity burningBall = (BurningBallEntity)((EntityType)ModEntities.BURNING_BALL.get()).create(level);
                        if (burningBall != null) {
                            burningBall.setOwner((Entity)player);
                            burningBall.setPos(player.getX(), player.getEyeY() + 0.1, player.getZ());
                            burningBall.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, powerForTime * 3.0f, 0.5f);
                            level.addFreshEntity((Entity)burningBall);
                            player.getCooldowns().addCooldown(stack.getItem(), 20);
                        }
                    } else {
                        AbstractArrow abstractarrow = this.customArrow((AbstractArrow)new BurningArrowEntity((Entity)player));
                        abstractarrow = this.customArrow(abstractarrow);
                        abstractarrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, powerForTime * 3.0f, 0.5f);
                        if (draw == 1.0f) {
                            abstractarrow.setCritArrow(true);
                        }
                        abstractarrow.setBaseDamage(abstractarrow.getBaseDamage() * (double)DAMAGE_MULTIPLIER);
                        this.addEnchant(stack, level, (LivingEntity)player, abstractarrow, powerForTime);
                        level.addFreshEntity((Entity)abstractarrow);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), this.isActive(stack, "blaze_bow_burning") ? SoundEvents.SNOWBALL_THROW : SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    private void addEnchant(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity player, AbstractArrow arrowEntity, float powerForTime) {
        int k;
        int j = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)stack);
        if (j > 0) {
            arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.PUNCH_ARROWS, (ItemStack)stack)) > 0) {
            arrowEntity.setKnockback(k);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)stack) > 0) {
            arrowEntity.setSecondsOnFire(100);
        }
        stack.hurtAndBreak(1, player, livingEntity -> livingEntity.broadcastBreakEvent(player.getUsedItemHand()));
        arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
    }
}

