/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.common.entity.BladeSlashEntity;
import committee.nova.mods.avaritia.common.entity.arrow.NeutronArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class CrystalBowItem
extends BowItem
implements ISwitchable,
IBowTransform {
    public CrystalBowItem() {
        super(new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.switchMode(pLevel, player, hand, "blade_slash");
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(pLevel, player, hand);
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            boolean isBladeSlashActive = this.isActive(pStack, "blade_slash");
            boolean hasInfinity = player.getAbilities().instabuild || EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY_ARROWS, (ItemStack)pStack) > 0;
            ItemStack ammo = player.getProjectile(pStack);
            int chargeTime = this.getUseDuration(pStack) - pTimeLeft;
            if ((chargeTime = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)chargeTime, (!ammo.isEmpty() || hasInfinity ? 1 : 0) != 0)) < 0) {
                return;
            }
            float power = CrystalBowItem.getPowerForTime((int)chargeTime);
            if ((double)power >= 0.1) {
                if (!pLevel.isClientSide) {
                    if (isBladeSlashActive) {
                        BladeSlashEntity bladeSlash = new BladeSlashEntity(pLevel, (LivingEntity)player);
                        float speed = BladeSlashEntity.defaultSpeed * (1.0f + power * 2.0f);
                        float inaccuracy = 0.5f - power * 0.4f;
                        float yawOffset = 0.0f;
                        bladeSlash.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + yawOffset, 0.0f, speed, inaccuracy);
                        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)pStack);
                        float damageBoost = (float)powerLevel * 1.2f + power * 5.0f;
                        bladeSlash.damage += damageBoost;
                        bladeSlash.duration += (int)(power * 20.0f);
                        if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)pStack) > 0) {
                            bladeSlash.setSecondsOnFire(100);
                        }
                        pLevel.addFreshEntity((Entity)bladeSlash);
                        pLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 0.8f + power * 0.4f);
                    } else {
                        NeutronArrowEntity neutronArrow = new NeutronArrowEntity((EntityType<? extends Arrow>)((EntityType)ModEntities.NEUTRON_ARROW.get()), pLevel);
                        neutronArrow.setOwner((Entity)player);
                        neutronArrow.setPos(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
                        float speed = 3.0f;
                        float inaccuracy = 0.0f;
                        float yawOffset = 0.0f;
                        neutronArrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + yawOffset, 0.0f, speed, inaccuracy);
                        pLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 0.8f + power * 0.4f);
                        pLevel.addFreshEntity((Entity)neutronArrow);
                    }
                    pStack.hurtAndBreak(1, (LivingEntity)player, user -> user.broadcastBreakEvent(player.getUsedItemHand()));
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public void onCraftedBy(ItemStack stack, @NotNull Level level, @NotNull Player player) {
        stack.enchant(Enchantments.INFINITY_ARROWS, 1);
        stack.enchant(Enchantments.MULTISHOT, 1);
        super.onCraftedBy(stack, level, player);
    }
}

