/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.iface.InitEnchantItem;
import committee.nova.mods.avaritia.common.entity.EndestPearlEntity;
import committee.nova.mods.avaritia.common.entity.TNTProEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityCrossBowItem
extends CrossbowItem
implements InitEnchantItem,
ISwitchable,
IUndamageable,
IBowTransform {
    public InfinityCrossBowItem() {
        super(new Item.Properties().stacksTo(1).rarity(ModRarities.COSMIC).fireResistant());
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)ModTooltips.INIT_ENCHANT.args(Enchantments.INFINITY_ARROWS.getFullname(10)).build());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.switchMode(level, player, hand, "infinity_crossbow_multi");
            return InteractionResultHolder.success((Object)stack);
        }
        if (InfinityCrossBowItem.isCharged((ItemStack)stack)) {
            this.performShooting(level, player, hand, stack, 1.0f, 1.0f);
            InfinityCrossBowItem.setCharged((ItemStack)stack, (boolean)false);
            return InteractionResultHolder.consume((Object)stack);
        }
        if (!level.isClientSide) {
            InfinityCrossBowItem.setCharged((ItemStack)stack, (boolean)true);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
    }

    public int getUseDuration(@NotNull ItemStack stack) {
        return 10;
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player) {
        super.onCraftedBy(stack, level, player);
        InfinityCrossBowItem.setCharged((ItemStack)stack, (boolean)true);
    }

    private void performShooting(Level level, Player player, InteractionHand hand, ItemStack crossbow, float velocity, float inaccuracy) {
        float[] fArray;
        int projectileCount;
        if (level.isClientSide) {
            return;
        }
        ItemStack ammo = this.findAmmo(player);
        boolean isMulti = this.isActive(crossbow, "infinity_crossbow_multi");
        int n = projectileCount = isMulti ? 5 : 1;
        if (isMulti) {
            float[] fArray2 = new float[5];
            fArray2[0] = -20.0f;
            fArray2[1] = -10.0f;
            fArray2[2] = 0.0f;
            fArray2[3] = 10.0f;
            fArray = fArray2;
            fArray2[4] = 20.0f;
        } else {
            float[] fArray3 = new float[1];
            fArray = fArray3;
            fArray3[0] = 0.0f;
        }
        float[] angles = fArray;
        for (int i = 0; i < projectileCount; ++i) {
            float angle = angles[Math.min(i, angles.length - 1)];
            if (!ammo.isEmpty()) {
                this.shootBasedOnAmmo(level, player, ammo, angle);
                continue;
            }
            this.shootInfnityArrow(level, player, 3.0f, 1.0f, angle);
        }
    }

    private void shootBasedOnAmmo(Level level, Player player, ItemStack ammo, float angle) {
        if (ammo.is(Items.ARROW)) {
            this.shootArrow(level, player, 3.0f, 1.0f, angle);
        } else if (ammo.is(Items.ENDER_PEARL)) {
            this.shootEnderPearl(level, player, angle);
        } else if (ammo.is(Items.FIRE_CHARGE)) {
            this.shootFireball(level, player, angle);
        } else if (ammo.is(Items.SPECTRAL_ARROW)) {
            this.shootSpectralArrow(level, player, 3.0f, 1.0f, angle);
        } else if (ammo.is(Items.TIPPED_ARROW)) {
            this.shootTippedArrow(level, player, ammo, 3.0f, 1.0f, angle);
        } else if (ammo.is(Items.FIREWORK_ROCKET)) {
            this.shootFireworkRocket(level, player, ammo, 3.0f, 1.0f, angle);
        } else if (ammo.is(Items.TRIDENT)) {
            this.shootTrident(level, player, ammo, 3.0f, 1.0f, angle);
        } else if (ammo.is(Items.SNOWBALL)) {
            this.shootSnowball(level, player, angle);
        } else if (ammo.is(Items.EGG)) {
            this.shootEgg(level, player, angle);
        } else if (ammo.is((Item)ModItems.endest_pearl.get())) {
            this.shootEndestPearl(level, player, angle);
        } else if (ammo.is(Items.TNT)) {
            this.shootTNT(level, player, angle);
        } else {
            this.shootInfnityArrow(level, player, 3.0f, 1.0f, angle);
        }
    }

    private ItemStack findAmmo(Player player) {
        if (this.isAmmo(player.getOffhandItem())) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    private boolean isAmmo(ItemStack stack) {
        return stack.is(Items.ARROW) || stack.is(Items.ENDER_PEARL) || stack.is(Items.FIRE_CHARGE) || stack.is(Items.SPECTRAL_ARROW) || stack.is(Items.TIPPED_ARROW) || stack.is(Items.FIREWORK_ROCKET) || stack.is(Items.TRIDENT) || stack.is(Items.SNOWBALL) || stack.is(Items.EGG) || stack.is((Item)ModItems.endest_pearl.get()) || stack.is(Items.TNT);
    }

    private void shootInfnityArrow(Level level, Player player, float velocity, float inaccuracy, float angle) {
        HeavenArrowEntity arrow = new HeavenArrowEntity(level, (Entity)player);
        arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, velocity, inaccuracy);
        level.addFreshEntity((Entity)arrow);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootArrow(Level level, Player player, float velocity, float inaccuracy, float angle) {
        Arrow arrow = new Arrow(level, (LivingEntity)player);
        arrow.setEffectsFromItem(new ItemStack((ItemLike)Items.ARROW));
        arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, velocity, inaccuracy);
        level.addFreshEntity((Entity)arrow);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootEnderPearl(Level level, Player player, float angle) {
        ThrownEnderpearl pearl = new ThrownEnderpearl(level, (LivingEntity)player);
        pearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)pearl);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootFireball(Level level, Player player, float angle) {
        SmallFireball fireball = new SmallFireball(level, (LivingEntity)player, player.getLookAngle().x, player.getLookAngle().y, player.getLookAngle().z);
        fireball.setPos(player.getX(), player.getEyeY(), player.getZ());
        fireball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, 1.0f, 1.0f);
        level.addFreshEntity((Entity)fireball);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BLAZE_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootSpectralArrow(Level level, Player player, float velocity, float inaccuracy, float angle) {
        SpectralArrow arrow = new SpectralArrow(level, (LivingEntity)player);
        arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, velocity, inaccuracy);
        level.addFreshEntity((Entity)arrow);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootTippedArrow(Level level, Player player, ItemStack ammo, float velocity, float inaccuracy, float angle) {
        Arrow arrow = new Arrow(level, (LivingEntity)player);
        arrow.setEffectsFromItem(ammo);
        arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, velocity, inaccuracy);
        level.addFreshEntity((Entity)arrow);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootFireworkRocket(Level level, Player player, ItemStack fireworkItem, float velocity, float inaccuracy, float angle) {
        FireworkRocketEntity firework = new FireworkRocketEntity(level, fireworkItem, (Entity)player, player.getX(), player.getEyeY(), player.getZ(), true);
        Vec3 lookVec = player.getLookAngle();
        if (angle != 0.0f) {
            lookVec = lookVec.yRot((float)Math.toRadians(angle));
        }
        Vec3 motion = lookVec.scale((double)velocity);
        if (inaccuracy > 0.0f) {
            motion = motion.add(level.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, level.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, level.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
        }
        firework.setDeltaMovement(motion);
        firework.setPos(player.getX(), player.getEyeY(), player.getZ());
        level.addFreshEntity((Entity)firework);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FIREWORK_ROCKET_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootTrident(Level level, Player player, ItemStack trident, float velocity, float inaccuracy, float angle) {
        ThrownTrident tridentEntity = new ThrownTrident(level, (LivingEntity)player, trident);
        tridentEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, velocity, inaccuracy);
        level.addFreshEntity((Entity)tridentEntity);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootSnowball(Level level, Player player, float angle) {
        Snowball snowball = new Snowball(level, (LivingEntity)player);
        snowball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)snowball);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootEgg(Level level, Player player, float angle) {
        ThrownEgg egg = new ThrownEgg(level, (LivingEntity)player);
        egg.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)egg);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootEndestPearl(Level level, Player player, float angle) {
        EndestPearlEntity pearl = new EndestPearlEntity(level, (LivingEntity)player);
        pearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + angle, 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)pearl);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootTNT(Level level, Player player, float angle) {
        TNTProEntity tnt = new TNTProEntity(level, player.getX(), player.getEyeY(), player.getZ(), (LivingEntity)player);
        Vec3 lookVec = player.getLookAngle();
        if (angle != 0.0f) {
            lookVec = lookVec.yRot((float)Math.toRadians(angle));
        }
        tnt.setDeltaMovement(lookVec.scale(1.5));
        level.addFreshEntity((Entity)tnt);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TNT_PRIMED, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.INFINITY_ARROWS ? 10 : 0;
    }
}

