/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import committee.nova.mods.avaritia.api.iface.IFilterItem;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.iface.InitEnchantItem;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityPickaxeItem
extends PickaxeItem
implements InitEnchantItem,
IFilterItem,
ISwitchable,
ITooltip,
IUndamageable {
    public InfinityPickaxeItem() {
        super(ModToolTiers.INFINITY, -50, 0.0f, new Item.Properties().rarity(ModRarities.COSMIC).stacksTo(1).fireResistant());
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        if (this.isActive(stack, "infinity_pickaxe_hammer")) {
            return 8888.0f;
        }
        return Math.max(super.getDestroySpeed(stack, state), 9999.0f);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.switchMode(world, player, hand, "infinity_pickaxe_hammer");
            return InteractionResultHolder.success((Object)stack);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.SILK_TOUCH, (ItemStack)stack) > 0) {
            ItemUtils.clearEnchants(stack);
            stack.enchant(Enchantments.BLOCK_FORTUNE, 10);
            return InteractionResultHolder.success((Object)stack);
        }
        ItemUtils.clearEnchants(stack);
        stack.enchant(Enchantments.SILK_TOUCH, 1);
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity victim, @NotNull LivingEntity player) {
        if (this.isActive(stack, "infinity_pickaxe_hammer") && !(victim instanceof Player)) {
            int i = 10;
            victim.setDeltaMovement((double)(-Mth.sin((float)(player.yBodyRot * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 2.0, (double)(Mth.cos((float)(player.yBodyRot * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
        }
        return true;
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity miningEntity) {
        if (miningEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)miningEntity;
            if (this.isActive(stack, "infinity_pickaxe_hammer")) {
                ToolUtils.destroyMaterialBlocks(player, pos, (Integer)ModConfig.pickAxeBreakRange.get(), ToolUtils.materialsPick);
            }
        }
        return false;
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.BLOCK_FORTUNE ? 20 : 0;
    }

    @Override
    public boolean hasDescTooltip() {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)this.getTier().getAttackDamageBonus(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)this.getTier().getSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

