/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.menu.BaseTileMenu;
import committee.nova.mods.avaritia.api.common.slot.ItemStackWrapperSlot;
import committee.nova.mods.avaritia.api.common.slot.OutputSlot;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class NeutronCompressorMenu
extends BaseTileMenu<NeutronCompressorTile> {
    private final ContainerData progressData;

    public NeutronCompressorMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, NeutronCompressorTile.createInventoryHandler(), buffer.readBlockPos(), (ContainerData)new SimpleContainerData(1));
    }

    public NeutronCompressorMenu(int id, Inventory playerInventory, ItemStackWrapper inventory, BlockPos pos, ContainerData data) {
        super((MenuType)ModMenus.compressor.get(), id, playerInventory, pos);
        this.progressData = data;
        this.addDataSlots(this.progressData);
        inventory.setSlotValidator((integer, itemStack) -> {
            if (integer == 1) {
                NeutronCompressorTile compressor;
                BlockEntity tile = this.level.getBlockEntity(pos);
                if (tile instanceof NeutronCompressorTile && (compressor = (NeutronCompressorTile)tile).isRecipeLocked() && compressor.getLockedRecipe() != null) {
                    NonNullList ingredients = compressor.getLockedRecipe().getIngredients();
                    if (!ingredients.isEmpty()) {
                        Ingredient ingredient = (Ingredient)ingredients.get(0);
                        ItemStack[] items = ingredient.getItems();
                        return items.length > 0 && itemStack.is(items[0].getItem());
                    }
                    return false;
                }
                List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get());
                if (recipes.isEmpty()) {
                    return true;
                }
                for (ICompressorRecipe recipe : recipes) {
                    Ingredient ingredient;
                    ItemStack[] items;
                    NonNullList ingredients = recipe.getIngredients();
                    if (ingredients.isEmpty() || (items = (ingredient = (Ingredient)ingredients.get(0)).getItems()).length <= 0 || !itemStack.is(items[0].getItem())) continue;
                    return true;
                }
                return false;
            }
            return true;
        });
        this.addSlot((Slot)new OutputSlot((IItemHandler)inventory, 0, 120, 35));
        this.addSlot((Slot)new ItemStackWrapperSlot(inventory, 1, 39, 35));
        this.createInventorySlots(playerInventory);
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNumber == 0) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotNumber >= 2 && slotNumber < 38 ? !this.moveItemStackTo(itemstack1, 1, 2, false) && (slotNumber < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : !this.moveItemStackTo(itemstack1, 11, 29, false)) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progressData.get(0);
    }

    @Override
    public NeutronCompressorTile getTileEntity() {
        if (this.level != null) {
            NeutronCompressorTile tile;
            BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos());
            return blockEntity instanceof NeutronCompressorTile ? (tile = (NeutronCompressorTile)blockEntity) : null;
        }
        return null;
    }
}

