/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.slot.FakeSlot;
import committee.nova.mods.avaritia.api.util.game.CraftingRecipeGridIndexGetter;
import committee.nova.mods.avaritia.api.util.math.InvItemCounter;
import committee.nova.mods.avaritia.common.container.DummyChannelContainer;
import committee.nova.mods.avaritia.common.menu.provider.ChannelSelectMenuProvider;
import committee.nova.mods.avaritia.common.net.channel.C2SChannelActionPack;
import committee.nova.mods.avaritia.common.tile.TesseractTile;
import committee.nova.mods.avaritia.core.channel.Channel;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import committee.nova.mods.avaritia.core.channel.ItemChannelTerminal;
import committee.nova.mods.avaritia.core.channel.ServerChannel;
import committee.nova.mods.avaritia.core.channel.ServerChannelManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class TesseractMenu
extends AbstractContainerMenu {
    public final Channel channel;
    public final UUID owner;
    public final Player player;
    public final Level level;
    private final BlockPos blockPos;
    private final int panelItemSlotIndex;
    private final ItemStack panelItem;
    private final TransientCraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    public DummyChannelContainer dummyChannelContainer = new DummyChannelContainer(this);
    public TesseractTile tesseractTile;
    public boolean locked;
    public UUID channelOwner;
    public int channelID;
    public boolean craftingMode;
    public String filter;
    public byte sortType;
    public byte viewType;
    public boolean LShifting = false;
    public Runnable craftModeSetter;
    private CraftingRecipe lastCraftingRecipe;

    public TesseractMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.tesseract.get(), containerId);
        int j;
        int i;
        this.craftModeSetter = () -> {};
        this.lastCraftingRecipe = null;
        this.level = playerInv.player.level();
        this.player = playerInv.player;
        this.blockPos = extraData.readBlockPos();
        this.panelItemSlotIndex = extraData.readInt();
        this.owner = extraData.readUUID();
        this.locked = extraData.readBoolean();
        this.craftingMode = extraData.readBoolean();
        this.filter = extraData.readUtf(64);
        this.sortType = extraData.readByte();
        this.viewType = extraData.readByte();
        this.channelOwner = extraData.readUUID();
        this.channelID = extraData.readInt();
        this.panelItem = this.panelItemSlotIndex >= 0 ? this.player.getInventory().getItem(this.panelItemSlotIndex) : ItemStack.EMPTY;
        this.addSlots(playerInv.player, playerInv);
        this.channel = ClientChannelManager.getInstance().getChannel(this.dummyChannelContainer);
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 11; ++j) {
                this.addSlot(new FakeSlot((Container)this.dummyChannelContainer, i * 11 + j, 7 + j * 17, 17 + i * 17));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 11; ++j) {
                this.addSlot(new FakeSlot((Container)this.dummyChannelContainer, 77 + i * 11 + j, 7 + j * 17, 136 + i * 17){

                    public boolean isActive() {
                        return !TesseractMenu.this.craftingMode;
                    }
                });
            }
        }
    }

    public TesseractMenu(int containerId, Player player, TesseractTile blockEntity, int panelItemSlotIndex) {
        super((MenuType)ModMenus.tesseract.get(), containerId);
        this.craftModeSetter = () -> {};
        this.lastCraftingRecipe = null;
        this.level = player.level();
        this.player = player;
        this.panelItemSlotIndex = panelItemSlotIndex;
        if (panelItemSlotIndex >= 0) {
            this.blockPos = BlockPos.ZERO;
            this.tesseractTile = null;
            this.panelItem = player.getInventory().getItem(panelItemSlotIndex);
            CompoundTag nbt = this.panelItem.getOrCreateTag();
            this.owner = nbt.contains("owner") ? nbt.getUUID("owner") : player.getUUID();
            this.locked = nbt.getBoolean("locked");
            this.craftingMode = nbt.getBoolean("craftingMode");
            this.filter = nbt.getString("filter");
            this.sortType = nbt.getByte("sortType");
            this.viewType = nbt.getByte("viewType");
            CompoundTag channel = nbt.getCompound("channel");
            if (!channel.isEmpty()) {
                this.channelOwner = channel.getUUID("channelOwner");
                this.channelID = channel.getInt("channelID");
            }
        } else {
            this.blockPos = blockEntity.getBlockPos();
            this.tesseractTile = blockEntity;
            this.owner = blockEntity.getOwner() == null ? player.getUUID() : blockEntity.getOwner();
            this.locked = blockEntity.isLocked();
            this.craftingMode = blockEntity.isCraftingMode();
            this.filter = blockEntity.getFilter();
            this.sortType = blockEntity.getSortType();
            this.viewType = blockEntity.getViewType();
            this.channelOwner = blockEntity.getChannelOwner();
            this.channelID = blockEntity.getChannelID();
            this.panelItem = ItemStack.EMPTY;
        }
        this.channel = ServerChannelManager.getInstance().getChannel(this.channelOwner, this.channelID);
        if (!this.channel.isRemoved()) {
            ((ServerChannel)this.channel).addListener((ServerPlayer)player);
        }
        this.addSlots(player, player.getInventory());
    }

    @ParametersAreNonnullByDefault
    public boolean clickMenuButton(Player pPlayer, int pId) {
        switch (pId) {
            case 0: {
                if (!this.owner.equals(this.player.getUUID()) && !this.owner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) break;
                boolean bl = this.locked = !this.locked;
                if (this.panelItemSlotIndex >= 0) {
                    CompoundTag nbt = this.panelItem.getTag();
                    nbt.putBoolean("locked", this.locked);
                    if (this.locked) {
                        nbt.putBoolean("craftingMode", this.craftingMode);
                        nbt.putString("filter", this.filter);
                        nbt.putInt("sortType", (int)this.sortType);
                    }
                    this.panelItem.setTag(nbt);
                    break;
                }
                this.tesseractTile.setLocked(this.locked);
                if (!this.locked) break;
                this.saveBlock();
                break;
            }
            case 1: {
                this.craftingMode = !this.craftingMode;
                break;
            }
            case 2: {
                this.nextSort();
                break;
            }
            case 3: {
                this.reverseSort();
                break;
            }
            case 4: {
                this.changeViewType();
                break;
            }
            case 5: {
                this.openChannelScreen();
                break;
            }
            case 6: {
                this.craftToChannel(1);
                break;
            }
            case 7: {
                this.craftToChannel(8);
                break;
            }
            case 8: {
                this.craftToChannel(64);
                break;
            }
            case 9: {
                this.craftToChannel(512);
                break;
            }
            case 10: {
                this.craftToInventory(1);
                break;
            }
            case 11: {
                this.craftToInventory(8);
                break;
            }
            case 12: {
                this.craftToInventory(64);
                break;
            }
            case 13: {
                this.craftToInventory(512);
                break;
            }
            case 14: {
                this.craftAndDrop(1);
                break;
            }
            case 15: {
                this.craftAndDrop(8);
                break;
            }
            case 16: {
                this.craftAndDrop(64);
                break;
            }
            case 17: {
                this.craftAndDrop(512);
            }
        }
        return pId < 18;
    }

    public void action(int actionId, String type, String id) {
        switch (actionId) {
            case 0: {
                this.onLeftClickDummySlot(type, id);
                break;
            }
            case 1: {
                this.onRightClickDummySlot(type, id);
                break;
            }
            case 2: {
                this.onLeftShiftDummySlot(type, id);
                break;
            }
            case 3: {
                this.onRightShiftDummySlot(type, id);
                break;
            }
            case 4: {
                this.tryThrowOneFromDummySlot(type, id);
                break;
            }
            case 5: {
                this.tryThrowStickFromDummySlot(type, id);
                break;
            }
            case 6: {
                this.onLeftDragDummySlot(type, id);
                break;
            }
            case 7: {
                this.onRightDragDummySlot(type, id);
                break;
            }
            case 8: {
                this.onCloneFormDummySlot(type, id);
                break;
            }
            case 9: {
                this.onDragCloneDummySlot(type, id);
            }
        }
    }

    public void onLeftClickDummySlot(String type, String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (type.equals("item")) {
                this.setCarried(this.channel.saveTakeItem(id, false));
            } else if (type.equals("fluid")) {
                if (!this.channel.storageFluids.containsKey(id)) {
                    return;
                }
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
                if (fluidBucket.isEmpty()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.channel.takeItem("minecraft:bucket", 1);
                this.setCarried(fluidBucket);
            }
        } else {
            if (carried.getCount() > 1) {
                this.channel.addItem(carried);
                return;
            }
            if (type.equals("fluid") && carried.getItem().equals(Items.BUCKET)) {
                if (this.channel.storageFluids.get(id) < 1000L) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
                if (fluidBucket.isEmpty()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.setCarried(fluidBucket);
            } else {
                AtomicBoolean canal = new AtomicBoolean(false);
                if (type.equals("fluid")) {
                    carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                        if (!this.channel.storageFluids.containsKey(id)) {
                            return;
                        }
                        FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), (int)Math.min(1000L, this.channel.storageFluids.get(id)));
                        int filledAmount = iFluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        if (filledAmount != 0) {
                            boolean succeedInput = true;
                            int tanks = iFluidHandlerItem.getTanks();
                            ItemStack testItem = carried.copy();
                            AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                            for (int i = 0; i < tanks; ++i) {
                                int finalI = i;
                                testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                                if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(i))) continue;
                                succeedInput = false;
                                this.setCarried(this.getCarried().copy());
                                break;
                            }
                            if (succeedInput) {
                                this.channel.takeFluid(id, filledAmount);
                            }
                        }
                        canal.set(true);
                    });
                } else if (type.equals("energy") && id.equals("blackholestorage:forge_energy")) {
                    carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                        if (!iEnergyStorage.canReceive() || this.channel.getFEAmount() == 0) {
                            return;
                        }
                        int maxInputAmount = Math.min(1000000, this.channel.getFEAmount());
                        int receiveEnergy = iEnergyStorage.receiveEnergy(maxInputAmount, false);
                        if (receiveEnergy == 0) {
                            return;
                        }
                        this.channel.removeEnergy(Long.valueOf(receiveEnergy));
                        canal.set(true);
                    });
                } else if (type.equals("item")) {
                    carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        if (!this.channel.storageItems.containsKey(id)) {
                            return;
                        }
                        int slots = iItemHandler.getSlots();
                        for (int i = 0; i < slots; ++i) {
                            ItemStack remainingItem;
                            int remainingSlotSpace;
                            ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id));
                            if (!ItemStack.isSameItemSameTags((ItemStack)tryInsertItem, (ItemStack)iItemHandler.getStackInSlot(i)) && !iItemHandler.getStackInSlot(i).isEmpty() || (remainingSlotSpace = iItemHandler.getSlotLimit(i) - iItemHandler.getStackInSlot(i).getCount()) <= 0) continue;
                            int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageItems.get(id) / 2L);
                            transmitAmount = Math.max(transmitAmount, 64000);
                            transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageItems.get(id));
                            int markAmount = transmitAmount = Math.min(transmitAmount, remainingSlotSpace);
                            tryInsertItem.setCount(transmitAmount);
                            for (int j = 0; j < 64 && (transmitAmount = (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).getCount()) > 0; ++j) {
                                tryInsertItem.setCount(transmitAmount);
                            }
                            if ((markAmount -= transmitAmount) <= 0) continue;
                            this.channel.takeItem(id, markAmount);
                            canal.set(true);
                            return;
                        }
                    });
                }
                if (canal.get()) {
                    return;
                }
                this.channel.addItem(carried);
            }
        }
    }

    public void onRightClickDummySlot(String type, String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (type.equals("item")) {
                this.setCarried(this.channel.saveTakeItem(id, true));
            }
            if (type.equals("fluid")) {
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
                if (fluidBucket.isEmpty()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.channel.takeItem("minecraft:bucket", 1);
                this.setCarried(fluidBucket);
            }
        } else {
            if (carried.getCount() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                int canStoredAmount;
                FluidStack resultFluidStack = iFluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (iFluidHandlerItem instanceof FluidBucketWrapper) {
                    this.channel.addFluid(resultFluidStack);
                    this.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                    canal.set(true);
                    return;
                }
                if (!resultFluidStack.isEmpty() && (canStoredAmount = this.channel.canStorageAmount(resultFluidStack)) > 0) {
                    resultFluidStack.setAmount(Math.min(resultFluidStack.getAmount(), canStoredAmount));
                    resultFluidStack = iFluidHandlerItem.drain(resultFluidStack, IFluidHandler.FluidAction.EXECUTE);
                    if (!resultFluidStack.isEmpty()) {
                        int tanks = iFluidHandlerItem.getTanks();
                        ItemStack testItem = carried.copy();
                        AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                        for (int i = 0; i < tanks; ++i) {
                            int finalI = i;
                            testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                            if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(i))) continue;
                            this.setCarried(this.getCarried().copy());
                            return;
                        }
                        this.channel.addFluid(resultFluidStack);
                        canal.set(true);
                    }
                }
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                if (!iEnergyStorage.canExtract() || iEnergyStorage.getEnergyStored() == 0) {
                    return;
                }
                int extractEnergy = iEnergyStorage.extractEnergy(Math.min(1000000, this.channel.canStorageFEAmount()), false);
                if (extractEnergy == 0) {
                    return;
                }
                this.channel.addEnergy(extractEnergy);
                canal.set(true);
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.isEmpty() || itemStack.hasTag() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.channel.canStorageAmount(itemStack), false)).isEmpty()) continue;
                    this.channel.addItem(itemStack);
                    canal.set(true);
                    break;
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void onLeftShiftDummySlot(String type, String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (type.equals("item")) {
                if (!this.channel.storageItems.containsKey(id)) {
                    return;
                }
                ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
                itemStack.setCount((int)Math.min((long)itemStack.getMaxStackSize(), this.channel.storageItems.get(id)));
                int i = itemStack.getCount();
                if (this.craftingMode) {
                    this.moveItemStackTo(itemStack, 41, 50, false);
                } else {
                    this.moveItemStackTo(itemStack, 0, 36, false);
                }
                if ((i -= itemStack.getCount()) > 0) {
                    itemStack.setCount(i);
                    this.channel.removeItem(itemStack);
                }
            } else if (type.equals("fluid")) {
                if (!this.channel.storageFluids.containsKey(id)) {
                    return;
                }
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
                if (fluidBucket.isEmpty()) {
                    return;
                }
                if (this.craftingMode) {
                    this.moveItemStackTo(fluidBucket, 41, 50, false);
                } else {
                    this.moveItemStackTo(fluidBucket, 0, 36, false);
                }
                if (fluidBucket.isEmpty()) {
                    this.channel.takeFluid(id, 1000);
                    this.channel.takeItem("minecraft:bucket", 1);
                }
            }
        } else {
            if (carried.getCount() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            if (type.equals("fluid") && carried.getItem().equals(Items.BUCKET)) {
                if (this.channel.storageFluids.get(id) < 1000L) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
                if (fluidBucket.isEmpty()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.setCarried(fluidBucket);
            } else {
                AtomicBoolean canal = new AtomicBoolean(false);
                if (type.equals("fluid")) {
                    carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                        if (!this.channel.storageFluids.containsKey(id)) {
                            return;
                        }
                        int tanks = iFluidHandlerItem.getTanks();
                        for (int i = 0; i < tanks; ++i) {
                            int remainingTankSpace;
                            FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1000);
                            if (!fluidStack.isFluidEqual(iFluidHandlerItem.getFluidInTank(i)) && !iFluidHandlerItem.getFluidInTank(i).isEmpty() || (remainingTankSpace = iFluidHandlerItem.getTankCapacity(i) - iFluidHandlerItem.getFluidInTank(i).getAmount()) <= 0) continue;
                            int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageFluids.get(id) / 2L);
                            transmitAmount = Math.max(transmitAmount, 64000000);
                            transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageFluids.get(id));
                            int markAmount = transmitAmount = Math.min(transmitAmount, remainingTankSpace);
                            fluidStack.setAmount(transmitAmount);
                            for (int j = 0; j < 1024; ++j) {
                                int filledAmount = iFluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                                if (j == 0) {
                                    ItemStack testItem = carried.copy();
                                    AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                                    int k = 0;
                                    while (k < tanks) {
                                        int finalI = k++;
                                        testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                                        if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(i))) continue;
                                        filledAmount = 0;
                                        this.setCarried(this.getCarried().copy());
                                        break;
                                    }
                                }
                                if (filledAmount == 0 || (transmitAmount -= filledAmount) <= 0) break;
                                fluidStack.setAmount(transmitAmount);
                            }
                            if ((markAmount -= transmitAmount) > 0) {
                                this.channel.takeFluid(id, markAmount);
                                canal.set(true);
                            }
                            return;
                        }
                    });
                } else if (type.equals("energy") && id.equals("blackholestorage:forge_energy")) {
                    carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                        int receiveEnergy;
                        int maxInputAmount;
                        if (!iEnergyStorage.canReceive() || this.channel.getFEAmount() == 0) {
                            return;
                        }
                        int markAmount = maxInputAmount = this.channel.getFEAmount();
                        for (int i = 0; i < 1024 && (receiveEnergy = iEnergyStorage.receiveEnergy(maxInputAmount, false)) != 0 && (maxInputAmount -= receiveEnergy) != 0; ++i) {
                        }
                        if ((markAmount -= maxInputAmount) > 0) {
                            this.channel.removeEnergy(Long.valueOf(markAmount));
                            canal.set(true);
                        }
                    });
                } else if (type.equals("item")) {
                    carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        if (!this.channel.storageItems.containsKey(id)) {
                            return;
                        }
                        int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageItems.get(id) / 2L);
                        transmitAmount = Math.max(transmitAmount, 64000);
                        int markAmount = transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageItems.get(id));
                        ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id), transmitAmount);
                        int slots = iItemHandler.getSlots();
                        for (int i = 0; i < slots; ++i) {
                            ItemStack remainingItem;
                            for (int j = 0; j < 64 && (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).getCount() != transmitAmount && (transmitAmount = remainingItem.getCount()) > 0; ++j) {
                                tryInsertItem.setCount(transmitAmount);
                            }
                        }
                        if ((markAmount -= transmitAmount) > 0) {
                            this.channel.takeItem(id, markAmount);
                            canal.set(true);
                        }
                    });
                }
                if (canal.get()) {
                    return;
                }
                this.channel.addItem(carried);
            }
        }
    }

    public void onRightShiftDummySlot(String type, String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (type.equals("item")) {
                if (!this.channel.storageItems.containsKey(id)) {
                    return;
                }
                ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
                if (this.craftingMode) {
                    this.moveItemStackTo(itemStack, 41, 50, false);
                } else {
                    this.moveItemStackTo(itemStack, 0, 36, false);
                }
                if (itemStack.isEmpty()) {
                    this.channel.takeItem(id, 1);
                }
            } else if (type.equals("fluid")) {
                if (!this.channel.storageFluids.containsKey(id)) {
                    return;
                }
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
                if (fluidBucket.isEmpty()) {
                    return;
                }
                if (this.craftingMode) {
                    this.moveItemStackTo(fluidBucket, 41, 50, false);
                } else {
                    this.moveItemStackTo(fluidBucket, 0, 36, false);
                }
                if (fluidBucket.isEmpty()) {
                    this.channel.takeFluid(id, 1000);
                    this.channel.takeItem("minecraft:bucket", 1);
                }
            }
        } else {
            if (carried.getCount() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                FluidStack resultFluidStack = iFluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (iFluidHandlerItem instanceof FluidBucketWrapper) {
                    this.channel.addFluid(resultFluidStack);
                    this.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                    return;
                }
                if (!resultFluidStack.isEmpty()) {
                    String fluid = StorageUtils.getFluidId(resultFluidStack.getFluid());
                    long canStoredAmount = this.channel.canStorageRealAmount(resultFluidStack);
                    if (canStoredAmount > 0L) {
                        long removedAmount = 0L;
                        for (int i = 0; i < 1024; ++i) {
                            resultFluidStack.setAmount((int)Math.min(Integer.MAX_VALUE, canStoredAmount));
                            resultFluidStack = iFluidHandlerItem.drain(resultFluidStack, IFluidHandler.FluidAction.EXECUTE);
                            if (resultFluidStack.isEmpty()) break;
                            if (i == 0) {
                                int tanks = iFluidHandlerItem.getTanks();
                                ItemStack testItem = carried.copy();
                                AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                                for (int j = 0; j < tanks; ++j) {
                                    int finalI = j;
                                    testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                                    if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(j))) continue;
                                    this.setCarried(this.getCarried().copy());
                                    return;
                                }
                            }
                            canStoredAmount -= (long)resultFluidStack.getAmount();
                            removedAmount += (long)resultFluidStack.getAmount();
                        }
                        if (removedAmount > 0L) {
                            this.channel.addFluid(fluid, removedAmount);
                            canal.set(true);
                        }
                    }
                }
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                int extractEnergy;
                int maxRemoveAmount;
                if (!iEnergyStorage.canExtract() || iEnergyStorage.getEnergyStored() == 0) {
                    return;
                }
                int markAmount = maxRemoveAmount = this.channel.canStorageFEAmount();
                for (int i = 0; i < 1024 && (extractEnergy = iEnergyStorage.extractEnergy(Math.min(iEnergyStorage.getEnergyStored(), maxRemoveAmount), false)) != 0 && iEnergyStorage.getEnergyStored() > 0 && (maxRemoveAmount -= extractEnergy) > 0; ++i) {
                }
                if ((markAmount -= maxRemoveAmount) > 0) {
                    this.channel.addEnergy(markAmount);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.isEmpty() || itemStack.hasTag() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.channel.canStorageAmount(itemStack), false)).isEmpty()) continue;
                    this.channel.addItem(itemStack);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void tryThrowOneFromDummySlot(String type, String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (type.equals("item")) {
            if (!this.channel.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = this.channel.takeItem(id, 1);
            this.player.drop(itemStack, false);
        } else if (type.equals("fluid")) {
            if (!this.channel.storageFluids.containsKey(id)) {
                return;
            }
            if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                return;
            }
            FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
            ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
            if (fluidBucket.isEmpty()) {
                return;
            }
            this.channel.takeFluid(id, 1000);
            this.channel.takeItem("minecraft:bucket", 1);
            this.player.drop(fluidBucket, false);
        }
    }

    public void tryThrowStickFromDummySlot(String type, String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (type.equals("item")) {
            if (!this.channel.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = this.channel.saveTakeItem(id, false);
            this.player.drop(itemStack, false);
        } else if (type.equals("fluid")) {
            if (!this.channel.storageFluids.containsKey(id)) {
                return;
            }
            if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                return;
            }
            FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
            ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().getBucket());
            if (fluidBucket.isEmpty()) {
                return;
            }
            this.channel.takeFluid(id, 1000);
            this.channel.takeItem("minecraft:bucket", 1);
            this.player.drop(fluidBucket, false);
        }
    }

    public void onLeftDragDummySlot(String type, String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        this.channel.addItem(carried);
    }

    public void onRightDragDummySlot(String type, String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        this.channel.fillItemStack(carried, -1);
    }

    public void onCloneFormDummySlot(String type, String id) {
        if (id.equals("minecraft:air") || !this.player.isCreative()) {
            return;
        }
        switch (type) {
            case "item": {
                this.channel.addItem(id, Long.max(this.channel.getRealItemAmount(id), 64L));
                break;
            }
            case "fluid": {
                this.channel.addFluid(id, Long.max(this.channel.getRealFluidAmount(id), 1000L));
                break;
            }
            case "energy": {
                this.channel.addEnergy(id, Long.max(this.channel.getRealEnergyAmount(id), 1000L));
            }
        }
    }

    public void onDragCloneDummySlot(String type, String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        ItemStack itemStack = carried.copy();
        itemStack.setCount(itemStack.getMaxStackSize());
        this.channel.addItem(itemStack);
    }

    private void addSlots(Player player, Inventory playerInv) {
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInv, l, 23 + l * 17, 258));
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInv, i1 + k * 9 + 9, 23 + i1 * 17, 195 + k * 17));
            }
        }
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.HEAD, 39, 7, 139));
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.CHEST, 38, 7, 156));
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.LEGS, 37, 58, 139));
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.FEET, 36, 58, 156));
        this.addSlot(new Slot((Container)playerInv, 40, 7, 173){

            public boolean isActive() {
                return TesseractMenu.this.craftingMode;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftSlots, j + i * 3, 92 + j * 17, 139 + i * 17){

                    public boolean isActive() {
                        return TesseractMenu.this.craftingMode;
                    }
                });
            }
        }
        this.addSlot((Slot)new ResultSlot(player, (CraftingContainer)this.craftSlots, (Container)this.resultSlots, 0, 161, 156){

            public boolean isActive() {
                return TesseractMenu.this.craftingMode;
            }
        });
    }

    private Slot getArmorSlot(final Player player, Inventory inventory, final EquipmentSlot equipmentslot, int slotId, int x, int y) {
        return new Slot((Container)inventory, slotId, x, y){

            @ParametersAreNonnullByDefault
            public void set(ItemStack itemStack) {
                ItemStack itemstack = this.getItem();
                super.set(itemStack);
                player.onEquipItem(equipmentslot, itemstack, itemStack);
            }

            public int getMaxStackSize() {
                return 1;
            }

            @ParametersAreNonnullByDefault
            public boolean mayPlace(ItemStack itemStack) {
                return itemStack.canEquip(equipmentslot, (Entity)player);
            }

            @ParametersAreNonnullByDefault
            public boolean mayPickup(Player player1) {
                ItemStack itemstack = this.getItem();
                return (itemstack.isEmpty() || player1.isCreative() || !EnchantmentHelper.hasBindingCurse((ItemStack)itemstack)) && super.mayPickup(player1);
            }

            public boolean isActive() {
                return TesseractMenu.this.craftingMode;
            }
        };
    }

    protected void clearCraftSlots() {
        for (int j = 0; j < this.craftSlots.getContainerSize(); ++j) {
            ItemStack itemStack = this.craftSlots.removeItemNoUpdate(j);
            this.channel.addItem(itemStack);
            if (itemStack.isEmpty()) continue;
            this.pushToInventory(itemStack);
        }
    }

    public void nextSort() {
        this.sortType = (byte)(this.sortType + 2);
        if (this.sortType > 7) {
            this.sortType = (byte)(this.sortType % 8);
        }
        if (this.level.isClientSide) {
            this.dummyChannelContainer.refreshContainer(true);
        }
    }

    public void reverseSort() {
        this.sortType = this.sortType % 2 == 0 ? (byte)(this.sortType + 1) : (byte)(this.sortType - 1);
        if (this.level.isClientSide) {
            this.dummyChannelContainer.refreshContainer(true);
        }
    }

    public void changeViewType() {
        this.viewType = this.viewType == 2 ? (byte)0 : (byte)(this.viewType + 1);
        if (this.level.isClientSide) {
            this.dummyChannelContainer.onChangeViewType();
        }
    }

    private void saveBlock() {
        this.tesseractTile.setCraftingMode(this.craftingMode);
        this.tesseractTile.setFilter(this.filter);
        this.tesseractTile.setSortType(this.sortType);
        this.tesseractTile.setViewType(this.viewType);
    }

    @ParametersAreNonnullByDefault
    public void clicked(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId >= 51) {
            String[] object = pSlotId - 51 < this.dummyChannelContainer.viewingObject.size() ? this.dummyChannelContainer.viewingObject.get(pSlotId - 51) : new String[]{"item", "minecraft:air"};
            block0 : switch (pButton) {
                case 0: {
                    switch (pClickType) {
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 2, object));
                            this.onLeftShiftDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 0, object));
                            this.onLeftClickDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 4, object));
                            this.tryThrowOneFromDummySlot(object[0], object[1]);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (pClickType) {
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 1, object));
                            this.onRightClickDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 3, object));
                            this.onRightShiftDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case QUICK_CRAFT: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 6, object));
                            this.onLeftDragDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 5, object));
                            this.tryThrowStickFromDummySlot(object[0], object[1]);
                        }
                    }
                    break;
                }
                case 4: {
                    if (pClickType != ClickType.CLONE) break;
                    if (object[0].equals("item") && object[1].equals("minecraft:air")) {
                        return;
                    }
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 8, object));
                    this.onCloneFormDummySlot(object[0], object[1]);
                    break;
                }
                case 5: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 7, object));
                    this.onRightDragDummySlot(object[0], object[1]);
                    break;
                }
                case 9: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.containerId, 9, object));
                    this.onDragCloneDummySlot(object[0], object[1]);
                }
            }
        } else if (pSlotId >= 41 && pSlotId <= 49 && pClickType.equals((Object)ClickType.QUICK_MOVE)) {
            ItemStack itemStack = ((Slot)this.slots.get(pSlotId)).getItem();
            if (pButton == 0) {
                this.moveItemStackTo(itemStack, 9, 36, false);
                if (!itemStack.isEmpty()) {
                    this.moveItemStackTo(itemStack, 0, 9, false);
                }
                this.slotsChanged((Container)this.craftSlots);
            } else if (pButton == 1) {
                this.channel.addItem(itemStack);
                this.slotsChanged((Container)this.craftSlots);
            } else {
                super.clicked(pSlotId, pButton, pClickType, pPlayer);
            }
        } else if (pSlotId != this.panelItemSlotIndex) {
            super.clicked(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack quickMoveStack(Player player, int slotId) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotId);
        if (slot.hasItem()) {
            ItemStack movingStack = slot.getItem();
            itemStack = movingStack.copy();
            if (slotId >= 0 && slotId <= 35) {
                if (!this.craftingMode) {
                    this.channel.addItem(movingStack);
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(movingStack, 41, 50, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (slotId == 50) {
                movingStack.getItem().onCraftedBy(movingStack, this.level, player);
                if (!this.moveItemStackTo(movingStack, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(movingStack, itemStack);
            } else if (slotId >= 41 && slotId <= 49) {
                if (!this.moveItemStackTo(movingStack, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                Const.LOGGER.warn("Ohh! Who trigger the quickMoveStack() when slotId >= 51 in server side ?");
            }
            if (movingStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (movingStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, movingStack);
            if (slotId == 50) {
                player.drop(movingStack, false);
            }
        }
        return itemStack;
    }

    @ParametersAreNonnullByDefault
    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.index <= 49;
    }

    @ParametersAreNonnullByDefault
    public boolean stillValid(Player player) {
        if (this.channel.isRemoved()) {
            if (this.panelItemSlotIndex >= 0) {
                CompoundTag nbt = this.panelItem.getTag();
                nbt.remove("channel");
                this.panelItem.setTag(nbt);
            } else {
                this.tesseractTile.setChannel(null, -1);
            }
            this.openChannelScreen();
        }
        if (this.panelItemSlotIndex >= 0) {
            return this.panelItem == player.getInventory().getItem(this.panelItemSlotIndex);
        }
        return !this.tesseractTile.isRemoved() && player.distanceToSqr((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY() + 0.5, (double)this.blockPos.getZ() + 0.5) <= 32.0;
    }

    @ParametersAreNonnullByDefault
    public void removed(Player player) {
        if (this.level.isClientSide) {
            return;
        }
        if (!this.channel.isRemoved()) {
            ((ServerChannel)this.channel).removeListener((ServerPlayer)player);
        }
        super.removed(player);
        this.clearCraftSlots();
        if (this.panelItemSlotIndex >= 0) {
            CompoundTag nbt = this.panelItem.getTag();
            if (!nbt.getBoolean("locked")) {
                nbt.putBoolean("locked", this.locked);
                nbt.putBoolean("craftingMode", this.craftingMode);
                nbt.putString("filter", this.filter);
                nbt.putByte("sortType", this.sortType);
                nbt.putByte("viewType", this.viewType);
                if (this.channel.isRemoved()) {
                    nbt.remove("channel");
                }
                this.panelItem.setTag(nbt);
            }
        } else if (!this.tesseractTile.isLocked()) {
            this.saveBlock();
        }
    }

    private void openChannelScreen() {
        if (this.locked) {
            return;
        }
        if (this.panelItemSlotIndex >= 0) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)this.player), (MenuProvider)new ChannelSelectMenuProvider(new ItemChannelTerminal(this.player.getInventory(), this.panelItem, this.panelItemSlotIndex)), buf -> {});
        } else {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)this.player), (MenuProvider)new ChannelSelectMenuProvider(this.tesseractTile), buf -> {});
        }
    }

    @ParametersAreNonnullByDefault
    public void slotsChanged(Container container) {
        if (this.level.isClientSide) {
            return;
        }
        if (this.lastCraftingRecipe != null && this.lastCraftingRecipe.matches((Container)this.craftSlots, this.level)) {
            this.resultSlots.setRecipeUsed(this.level, (ServerPlayer)this.player, (Recipe)this.lastCraftingRecipe);
            this.resultSlots.setItem(0, this.lastCraftingRecipe.assemble((Container)this.craftSlots, this.level.registryAccess()));
            return;
        }
        Optional optional = this.level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.craftSlots, this.level);
        if (optional.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)optional.get();
            if (this.resultSlots.setRecipeUsed(this.level, (ServerPlayer)this.player, (Recipe)recipe)) {
                this.resultSlots.setItem(0, recipe.assemble((Container)this.craftSlots, this.level.registryAccess()));
            }
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        }
    }

    public void receivedRecipe(String recipeId, boolean maxTransfer) {
        Optional optional1;
        int i;
        if (this.level.getServer() == null) {
            return;
        }
        RecipeManager manager = this.level.getServer().getRecipeManager();
        Optional optional = manager.byKey(new ResourceLocation(recipeId));
        if (optional.isEmpty()) {
            return;
        }
        Inventory inventory = this.player.getInventory();
        Object t = optional.get();
        if (!(t instanceof CraftingRecipe)) {
            return;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)t;
        this.craftingMode = true;
        this.clearCraftSlots();
        this.slotsChanged((Container)this.craftSlots);
        NonNullList ingredients = craftingRecipe.getIngredients();
        HashMap<Item, Long> itemAmount = new HashMap<Item, Long>();
        HashMap<Item, Integer> itemP = new HashMap<Item, Integer>();
        InvItemCounter invItemCounter = null;
        ArrayList<Object> itemChosen = new ArrayList<Object>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) {
                itemChosen.add(null);
                continue;
            }
            ItemStack[] stacks = ingredient.getItems();
            long markCount = 0L;
            Item markItem = null;
            boolean hasNbtItem = false;
            for (ItemStack stack : stacks) {
                long count;
                if (stack.hasTag()) {
                    hasNbtItem = true;
                    continue;
                }
                Item item = stack.getItem();
                if (itemAmount.containsKey(item)) {
                    count = (Long)itemAmount.get(item);
                } else {
                    count = this.channel.getRealItemAmount(StorageUtils.getItemId(item));
                    if (count < 576L) {
                        if (invItemCounter == null) {
                            invItemCounter = new InvItemCounter(inventory);
                        }
                        count += (long)invItemCounter.getCount(item);
                    }
                    itemAmount.put(item, count);
                }
                if (count > markCount) {
                    markCount = count;
                    markItem = item;
                }
                if (itemP.containsKey(item)) {
                    itemP.replace(item, (Integer)itemP.get(item) + 1);
                    continue;
                }
                itemP.put(item, 1);
            }
            if (markItem == null && hasNbtItem) {
                itemChosen.add(Items.AIR);
                continue;
            }
            itemChosen.add(markItem);
        }
        CraftingRecipeGridIndexGetter recipeSlotIndexGetter = new CraftingRecipeGridIndexGetter(craftingRecipe);
        block2: for (i = 0; i < itemChosen.size(); ++i) {
            int gridIndex = recipeSlotIndexGetter.get();
            Item item = (Item)itemChosen.get(i);
            if (item == null) continue;
            if (item.equals(Items.AIR)) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                for (ItemStack itemStack : ingredient.getItems()) {
                    if (!itemStack.hasTag()) continue;
                    if (invItemCounter == null) {
                        invItemCounter = new InvItemCounter(inventory);
                    }
                    Integer[] itemIndex = invItemCounter.getNbtItemIndex();
                    boolean flag = false;
                    for (Integer index : itemIndex) {
                        ItemStack stack2 = inventory.getItem(index.intValue());
                        if (stack2.isEmpty() || !ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)stack2)) continue;
                        if (stack2.getCount() == 1) {
                            this.craftSlots.setItem(gridIndex, stack2);
                            inventory.setItem(index.intValue(), ItemStack.EMPTY);
                        } else {
                            ItemStack newStack = stack2.copy();
                            newStack.setCount(1);
                            this.craftSlots.setItem(gridIndex, newStack);
                            stack2.grow(-1);
                        }
                        flag = true;
                        break;
                    }
                    if (flag) continue block2;
                }
                continue;
            }
            if (this.channel.getRealItemAmount(StorageUtils.getItemId(item)) > 0L) {
                this.craftSlots.setItem(gridIndex, new ItemStack((ItemLike)item));
                this.channel.removeItem(StorageUtils.getItemId(item), 1L);
                continue;
            }
            if (invItemCounter == null) {
                invItemCounter = new InvItemCounter(inventory);
            }
            Integer[] itemIndex = invItemCounter.getNoNbtItemIndex();
            for (ItemStack itemStack : itemIndex) {
                ItemStack stack = inventory.getItem(itemStack.intValue());
                if (stack.isEmpty() || !stack.getItem().equals(item)) continue;
                if (stack.getCount() == 1) {
                    this.craftSlots.setItem(gridIndex, stack);
                    inventory.setItem(itemStack.intValue(), ItemStack.EMPTY);
                    continue block2;
                }
                this.craftSlots.setItem(gridIndex, new ItemStack((ItemLike)item));
                stack.grow(-1);
                continue block2;
            }
        }
        if (!craftingRecipe.matches((Container)this.craftSlots, this.level)) {
            return;
        }
        if (maxTransfer) {
            block6: for (i = 0; i < 9; ++i) {
                ItemStack itemStack = this.craftSlots.getItem(i);
                if (itemStack.isEmpty() || itemStack.hasTag() || itemStack.getMaxStackSize() == 1) continue;
                Item item = itemStack.getItem();
                String itemId = StorageUtils.getItemId(item);
                long amount = itemAmount.getOrDefault(item, 0L);
                int p = itemP.getOrDefault(item, 0);
                int n = (int)Long.min(itemStack.getMaxStackSize(), amount / (long)p);
                if (n < 2) continue;
                int channelHas = this.channel.getItemAmount(itemId);
                if (channelHas >= n) {
                    this.channel.removeItem(itemId, n - itemStack.getCount());
                    itemStack.setCount(n);
                    continue;
                }
                if (channelHas > 0) {
                    this.channel.removeItem(itemId, channelHas);
                    itemStack.setCount(itemStack.getCount() + channelHas);
                }
                if (invItemCounter == null) {
                    invItemCounter = new InvItemCounter(inventory);
                }
                Integer[] itemIndex = invItemCounter.getNoNbtItemIndex();
                for (Integer index : itemIndex) {
                    ItemStack invStack = inventory.getItem(index.intValue());
                    if (invStack.isEmpty() || invStack.hasTag() || !item.equals(invStack.getItem())) continue;
                    int invCount = invStack.getCount();
                    if (itemStack.getCount() + invCount > n) {
                        int j = itemStack.getCount() + invCount - n;
                        invStack.setCount(j);
                        itemStack.setCount(n);
                        continue;
                    }
                    inventory.setItem(index.intValue(), ItemStack.EMPTY);
                    itemStack.grow(invCount);
                    if (itemStack.getCount() >= n) continue block6;
                }
            }
        }
        if ((optional1 = manager.getRecipeFor(RecipeType.CRAFTING, (Container)this.craftSlots, this.level)).isPresent()) {
            CraftingRecipe currentRecipe = (CraftingRecipe)optional1.get();
            if (currentRecipe != craftingRecipe && craftingRecipe.matches((Container)this.craftSlots, this.level) && this.resultSlots.setRecipeUsed(this.level, (ServerPlayer)this.player, (Recipe)craftingRecipe)) {
                this.lastCraftingRecipe = craftingRecipe;
                this.resultSlots.setItem(0, craftingRecipe.assemble((Container)this.craftSlots, this.level.registryAccess()));
            }
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        }
    }

    public void receivedRecipe(Map<String, Integer> itemNeed) {
        itemNeed.forEach((s, integer) -> {
            ItemStack itemStack = this.channel.takeItem((String)s, (int)integer);
            if (itemStack.isEmpty()) {
                return;
            }
            this.savePushToInventory(itemStack);
        });
    }

    private void craftToChannel(int max) {
        ItemStack resultItem = this.resultSlots.getItem(0).copy();
        if (resultItem.isEmpty() || resultItem.hasTag()) {
            return;
        }
        Recipe recipe = this.resultSlots.getRecipeUsed();
        if (recipe instanceof CraftingRecipe) {
            int maxTry = max % resultItem.getCount() > 0 ? max / resultItem.getCount() + 1 : max / resultItem.getCount();
            int count = resultItem.getCount() * this.doCraft(resultItem, maxTry);
            long notInCount = (long)count - this.channel.addItem(StorageUtils.getItemId(resultItem.getItem()), count);
            if (notInCount > 0L) {
                resultItem.setCount((int)notInCount);
                this.pushToInventory(resultItem);
            }
        }
    }

    private void craftToInventory(int max) {
        ItemStack resultItem = this.resultSlots.getItem(0).copy();
        if (resultItem.isEmpty()) {
            return;
        }
        Recipe recipe = this.resultSlots.getRecipeUsed();
        if (recipe instanceof CraftingRecipe) {
            int maxTry1 = max % resultItem.getCount() > 0 ? max / resultItem.getCount() + 1 : max / resultItem.getCount();
            int maxSpace = 0;
            int maxStackSize = resultItem.getMaxStackSize();
            for (int i = 0; i < 36; ++i) {
                ItemStack slotStack = this.player.getInventory().getItem(i);
                if (slotStack.isEmpty()) {
                    maxSpace += maxStackSize;
                    continue;
                }
                if (maxStackSize <= 1 || !ItemStack.isSameItemSameTags((ItemStack)resultItem, (ItemStack)slotStack)) continue;
                maxSpace = maxSpace + maxStackSize - slotStack.getCount();
            }
            if (maxSpace <= 0) {
                return;
            }
            int maxTry2 = maxSpace / resultItem.getCount();
            int maxTry = Integer.min(maxTry1, maxTry2);
            int count = resultItem.getCount() * this.doCraft(resultItem, maxTry);
            resultItem.setCount(count);
            this.savePushToInventory(resultItem);
        }
    }

    private void craftAndDrop(int max) {
        ItemStack resultItem = this.resultSlots.getItem(0).copy();
        if (resultItem.isEmpty()) {
            return;
        }
        Recipe recipe = this.resultSlots.getRecipeUsed();
        if (recipe instanceof CraftingRecipe) {
            int maxTry = max % resultItem.getCount() > 0 ? max / resultItem.getCount() + 1 : max / resultItem.getCount();
            int count = resultItem.getCount() * this.doCraft(resultItem, maxTry);
            resultItem.setCount(count);
            this.player.drop(resultItem, false);
        }
    }

    private int doCraft(ItemStack resultItem, int maxTry) {
        int remainingCraftTry = maxTry - this.tryFastCraft(maxTry);
        if (remainingCraftTry > 0) {
            ArrayList<ItemStack> beforeItems = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                beforeItems.add(i, this.craftSlots.getItem(i).copy());
            }
            InvItemCounter invItemCounter = null;
            while (remainingCraftTry > 0) {
                if (remainingCraftTry > 1) {
                    for (int i = 0; i < 9; ++i) {
                        Integer[] noNbtItemIndex;
                        ItemStack craftingStack = this.craftSlots.getItem(i);
                        int maxStackSize = craftingStack.getMaxStackSize();
                        if (craftingStack.isEmpty() || maxStackSize == 1 || craftingStack.getCount() >= 2 || craftingStack.hasTag()) continue;
                        int channelAmount = this.channel.getItemAmount(StorageUtils.getItemId(craftingStack.getItem()));
                        if (channelAmount >= maxStackSize - 1) {
                            craftingStack.setCount(maxStackSize);
                            this.channel.removeItem(StorageUtils.getItemId(craftingStack.getItem()), maxStackSize - 1);
                            continue;
                        }
                        if (channelAmount > 0) {
                            this.channel.removeItem(StorageUtils.getItemId(craftingStack.getItem()), channelAmount);
                            craftingStack.setCount(channelAmount + 1);
                        }
                        if (invItemCounter == null) {
                            invItemCounter = new InvItemCounter(this.player.getInventory());
                        }
                        if (invItemCounter.getCount(craftingStack.getItem()) <= 0) continue;
                        for (Integer integer : noNbtItemIndex = invItemCounter.getNoNbtItemIndex()) {
                            this.applyFromInvIndex(craftingStack, integer);
                        }
                    }
                }
                ((Slot)this.slots.get(50)).onTake(this.player, resultItem);
                --remainingCraftTry;
                if (this.isSameResul(resultItem) || this.fixItems(resultItem, beforeItems)) continue;
                break;
            }
        }
        return maxTry - remainingCraftTry;
    }

    private int tryFastCraft(int maxTry) {
        HashMap<Item, Integer> itemMap = new HashMap<Item, Integer>();
        boolean canFastCraft = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack slotStack = this.craftSlots.getItem(i);
            if (slotStack.isEmpty()) continue;
            if (slotStack.hasTag() || slotStack.hasCraftingRemainingItem()) {
                canFastCraft = false;
                break;
            }
            if (itemMap.containsKey(slotStack.getItem())) {
                itemMap.replace(slotStack.getItem(), (Integer)itemMap.get(slotStack.getItem()) + 1);
                continue;
            }
            itemMap.put(slotStack.getItem(), 1);
        }
        if (canFastCraft) {
            Integer integer;
            Item item;
            int canTry = maxTry;
            for (Map.Entry entry : itemMap.entrySet()) {
                item = (Item)entry.getKey();
                integer = (Integer)entry.getValue();
                int needAmount = integer * canTry;
                int has = this.channel.getItemAmount(StorageUtils.getItemId(item));
                if (has >= needAmount || (canTry = has / integer) != 0) continue;
                break;
            }
            if (canTry > 0) {
                for (Map.Entry entry : itemMap.entrySet()) {
                    item = (Item)entry.getKey();
                    integer = (Integer)entry.getValue();
                    this.channel.removeItem(StorageUtils.getItemId(item), (long)integer.intValue() * (long)canTry);
                }
            }
            return canTry;
        }
        return 0;
    }

    private boolean fixItems(ItemStack resultItem, ArrayList<ItemStack> beforeItems) {
        for (int i = 0; i < 9; ++i) {
            ItemStack needStack;
            ItemStack craftingStack = this.craftSlots.getItem(i);
            if (ItemStack.isSameItemSameTags((ItemStack)craftingStack, (ItemStack)(needStack = beforeItems.get(i)))) continue;
            if (!craftingStack.isEmpty()) {
                this.channel.addItem(craftingStack);
                if (!craftingStack.isEmpty()) {
                    this.moveItemStackTo(craftingStack, 9, 36, false);
                }
                if (!craftingStack.isEmpty()) {
                    this.moveItemStackTo(craftingStack, 0, 9, false);
                }
                if (!craftingStack.isEmpty()) {
                    return false;
                }
            }
            if (!needStack.isEmpty()) {
                if (needStack.hasTag()) {
                    this.moveSameItemToCraftingSlot(i, needStack);
                } else {
                    int channelHas = this.channel.getItemAmount(StorageUtils.getItemId(needStack.getItem()));
                    if (channelHas >= needStack.getMaxStackSize()) {
                        this.craftSlots.setItem(i, this.channel.takeItem(StorageUtils.getItemId(needStack.getItem()), needStack.getMaxStackSize()));
                    } else if (channelHas == 0) {
                        this.moveSameItemToCraftingSlot(i, needStack);
                    } else {
                        this.craftSlots.setItem(i, this.channel.takeItem(StorageUtils.getItemId(needStack.getItem()), channelHas));
                        this.fillStackFromInventory(this.craftSlots.getItem(i));
                    }
                }
            }
            if (!this.isSameResul(resultItem)) continue;
            return true;
        }
        if (!this.isSameResul(resultItem)) {
            int i;
            ArrayList itemMark = new ArrayList();
            ArrayList<ItemStack> itemAmount = new ArrayList<ItemStack>();
            beforeItems.forEach(beforeItem -> {
                if (beforeItem.isEmpty()) {
                    return;
                }
                if (itemMark.size() == 0) {
                    ItemStack inItem = beforeItem.copy();
                    inItem.setCount(1);
                    itemMark.add(inItem);
                } else {
                    boolean flag = true;
                    for (ItemStack itemStack : itemMark) {
                        if (!ItemStack.isSameItemSameTags((ItemStack)beforeItem, (ItemStack)itemStack)) continue;
                        itemStack.setCount(itemStack.getCount() + 1);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        ItemStack inItem = beforeItem.copy();
                        inItem.setCount(1);
                        itemMark.add(inItem);
                    }
                }
            });
            for (i = 0; i < 9; ++i) {
                ItemStack slotItem = this.craftSlots.getItem(i);
                if (slotItem.isEmpty()) continue;
                if (itemAmount.size() == 0) {
                    ItemStack inItem = slotItem.copy();
                    itemAmount.add(inItem);
                } else {
                    boolean flag = true;
                    for (ItemStack itemStack : itemAmount) {
                        if (!ItemStack.isSameItemSameTags((ItemStack)slotItem, (ItemStack)itemStack)) continue;
                        itemStack.setCount(itemStack.getCount() + slotItem.getCount());
                        flag = false;
                        break;
                    }
                    if (flag) {
                        ItemStack inItem = slotItem.copy();
                        itemAmount.add(inItem);
                    }
                }
                this.craftSlots.setItem(i, ItemStack.EMPTY);
            }
            for (i = 0; i < 9; ++i) {
                ItemStack beforeStack = beforeItems.get(i);
                if (beforeStack.isEmpty()) continue;
                ItemStack p = ItemStack.EMPTY;
                ItemStack amount = ItemStack.EMPTY;
                for (ItemStack itemStack : itemMark) {
                    if (!ItemStack.isSameItemSameTags((ItemStack)beforeStack, (ItemStack)itemStack)) continue;
                    p = itemStack;
                    break;
                }
                for (ItemStack itemStack : itemAmount) {
                    if (!ItemStack.isSameItemSameTags((ItemStack)beforeStack, (ItemStack)itemStack)) continue;
                    amount = itemStack;
                    break;
                }
                if (p.isEmpty() || amount.isEmpty()) continue;
                ItemStack itemStack = beforeStack.copy();
                int count = amount.getCount() / p.getCount();
                itemStack.setCount(count);
                this.craftSlots.setItem(i, itemStack);
                amount.setCount(amount.getCount() - count);
                p.setCount(p.getCount() - 1);
            }
        }
        return this.isSameResul(resultItem);
    }

    private void pushToInventory(ItemStack itemStack) {
        this.moveItemStackTo(itemStack, 9, 36, false);
        if (!itemStack.isEmpty()) {
            this.moveItemStackTo(itemStack, 0, 9, false);
        }
        if (!itemStack.isEmpty()) {
            this.player.drop(itemStack, false);
        }
    }

    private void savePushToInventory(ItemStack itemStack) {
        int loops = itemStack.getCount() / itemStack.getMaxStackSize();
        for (int i = 0; i < loops; ++i) {
            ItemStack newStack = itemStack.copy();
            newStack.setCount(itemStack.getMaxStackSize());
            itemStack.setCount(itemStack.getCount() - itemStack.getMaxStackSize());
            this.pushToInventory(newStack);
        }
        if (itemStack.getCount() > 0) {
            this.pushToInventory(itemStack);
        }
    }

    private void fillStackFromInventory(ItemStack stack) {
        int i;
        int maxStackSize = stack.getMaxStackSize();
        for (i = 9; i < 36; ++i) {
            this.applyNbtFromInvIndex(stack, i);
            if (stack.getCount() >= maxStackSize) break;
        }
        if (stack.getCount() < maxStackSize) {
            for (i = 0; i < 9; ++i) {
                this.applyNbtFromInvIndex(stack, i);
                if (stack.getCount() >= maxStackSize) break;
            }
        }
    }

    private void applyFromInvIndex(ItemStack itemStack, int slotId) {
        if (itemStack.getItem().equals(this.player.getInventory().getItem(slotId).getItem())) {
            ItemStack otherStack = this.player.getInventory().getItem(slotId);
            int needAmount = itemStack.getMaxStackSize() - itemStack.getCount();
            if (otherStack.getCount() > needAmount) {
                itemStack.setCount(itemStack.getMaxStackSize());
                otherStack.setCount(otherStack.getCount() - needAmount);
            } else {
                itemStack.setCount(itemStack.getCount() + otherStack.getCount());
                this.player.getInventory().setItem(slotId, ItemStack.EMPTY);
            }
        }
    }

    private void applyNbtFromInvIndex(ItemStack itemStack, int slotId) {
        if (ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)this.player.getInventory().getItem(slotId))) {
            ItemStack otherStack = this.player.getInventory().getItem(slotId);
            int needAmount = itemStack.getMaxStackSize() - itemStack.getCount();
            if (otherStack.getCount() > needAmount) {
                itemStack.setCount(itemStack.getMaxStackSize());
                otherStack.setCount(otherStack.getCount() - needAmount);
            } else {
                itemStack.setCount(itemStack.getCount() + otherStack.getCount());
                this.player.getInventory().setItem(slotId, ItemStack.EMPTY);
            }
        }
    }

    private void moveSameItemToCraftingSlot(int slotIndex, ItemStack stack) {
        ItemStack otherStack;
        int i;
        boolean flag = true;
        for (i = 9; i < 36; ++i) {
            otherStack = this.player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)otherStack)) continue;
            this.craftSlots.setItem(slotIndex, otherStack);
            this.player.getInventory().setItem(i, ItemStack.EMPTY);
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < 9; ++i) {
                otherStack = this.player.getInventory().getItem(i);
                if (!ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)otherStack)) continue;
                this.craftSlots.setItem(slotIndex, otherStack);
                this.player.getInventory().setItem(i, ItemStack.EMPTY);
                break;
            }
        }
    }

    private boolean isSameResul(ItemStack itemStack) {
        return ItemStack.isSameItemSameTags((ItemStack)this.resultSlots.getItem(0), (ItemStack)itemStack) && this.resultSlots.getItem(0).getCount() == itemStack.getCount();
    }
}

