/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SCompressorLockPacket {
    private BlockPos pos;
    private boolean lockState;

    public C2SCompressorLockPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.lockState = buf.readBoolean();
    }

    public C2SCompressorLockPacket(BlockPos pos, boolean lockState) {
        this.pos = pos;
        this.lockState = lockState;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.lockState);
    }

    public void run(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(this.pos);
            if (tile instanceof NeutronCompressorTile) {
                NeutronCompressorTile compressor = (NeutronCompressorTile)tile;
                if (this.lockState && compressor.hasRecipe() && compressor.hasMaterialStack()) {
                    compressor.setRecipeLock(true, compressor.getActiveRecipe());
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7a[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u914d\u65b9\u5df2\u9501\u5b9a"));
                } else if (!this.lockState) {
                    compressor.setRecipeLock(false, null);
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7e[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u914d\u65b9\u5df2\u89e3\u9501"));
                } else if (!compressor.hasMaterialStack()) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7c[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u8bf7\u5148\u653e\u5165\u4e00\u4e2a\u914d\u65b9\u539f\u6599"));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

