/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SSideConfigPacket {
    private final BlockPos pos;
    private final SideConfiguration sideConfig;

    public C2SSideConfigPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.sideConfig = SideConfiguration.fromNetwork(buf);
    }

    public C2SSideConfigPacket(BlockPos pos, SideConfiguration sideConfig) {
        this.pos = pos;
        this.sideConfig = sideConfig;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        this.sideConfig.toNetwork(buf);
    }

    public void run(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerLevel level;
            BlockEntity tile;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level patt1530$temp = player.level();
            if (patt1530$temp instanceof ServerLevel && (tile = (level = (ServerLevel)patt1530$temp).getBlockEntity(this.pos)) instanceof ITileIO) {
                ITileIO tileIO = (ITileIO)tile;
                if (level.getBlockEntity(this.pos) == null) {
                    return;
                }
                tileIO.setSideConfiguration(this.sideConfig);
                Const.LOGGER.debug("\u65b9\u5757\u914d\u7f6e\u5df2\u66f4\u65b0");
                tileIO.setIOChange();
                NetworkHandler.sendSideConfigSync((Level)level, this.pos, this.sideConfig);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

