/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net.channel;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.menu.TesseractMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class C2SChannelFilterPack {
    private final int containerId;
    private final String filter;

    public C2SChannelFilterPack(FriendlyByteBuf buf) {
        this.containerId = buf.readInt();
        this.filter = buf.readUtf(64);
    }

    public C2SChannelFilterPack(int containerId, String filter) {
        this.containerId = containerId;
        this.filter = filter;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.containerId);
        buf.writeUtf(this.filter, 64);
    }

    public void run(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (player.containerMenu.containerId == this.containerId) {
                if (!player.containerMenu.stillValid((Player)player)) {
                    Const.LOGGER.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)player.containerMenu);
                } else {
                    ((TesseractMenu)player.containerMenu).filter = this.filter;
                    player.containerMenu.broadcastChanges();
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

