/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.CompressedChestMenu;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CompressedChestTile
extends ChestBlockEntity {
    protected final int SIZE = 243;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
            CompressedChestTile.playSound(pLevel, pPos, pState, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
            CompressedChestTile.playSound(pLevel, pPos, pState, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, int pEventId, int pEventParam) {
            CompressedChestTile.this.signalOpenCount(pLevel, pPos, pState, pEventId, pEventParam);
        }

        protected boolean isOwnContainer(@NotNull Player pPlayer) {
            AbstractContainerMenu abstractContainerMenu = pPlayer.containerMenu;
            if (abstractContainerMenu instanceof CompressedChestMenu) {
                CompressedChestMenu chestMenu = (CompressedChestMenu)abstractContainerMenu;
                Container container = chestMenu.getContainer();
                return container == CompressedChestTile.this || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)CompressedChestTile.this);
            }
            return false;
        }
    };
    protected CompoundTag chestTag;

    protected CompressedChestTile(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.setItems(NonNullList.withSize((int)243, (Object)ItemStack.EMPTY));
    }

    public CompressedChestTile(BlockPos pos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.compressed_chest_tile.get(), pos, blockState);
    }

    static void playSound(Level pLevel, BlockPos pPos, BlockState pState, SoundEvent pSound) {
        ChestType chesttype = (ChestType)pState.getValue((Property)ChestBlock.TYPE);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)pPos.getX() + 0.5;
            double d1 = (double)pPos.getY() + 0.5;
            double d2 = (double)pPos.getZ() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.getConnectedDirection((BlockState)pState);
                d0 += (double)direction.getStepX() * 0.5;
                d2 += (double)direction.getStepZ() * 0.5;
            }
            pLevel.playSound(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, pLevel.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    public int getContainerSize() {
        return 243;
    }

    @NotNull
    protected Component getDefaultName() {
        return Localizable.of("block.avaritia.compressed_chest").build();
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pInventory) {
        return new CompressedChestMenu(pContainerId, pInventory, this.getBlockPos(), 9);
    }

    public void startOpen(@NotNull Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(@NotNull Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level pLevel, BlockPos pPos, BlockState pState, int pEventId, int pEventParam) {
        Block block = pState.getBlock();
        pLevel.blockEvent(pPos, block, 1, pEventParam);
    }

    public CompoundTag getChestTag() {
        return this.chestTag;
    }

    public void setChestTag(CompoundTag chestTag) {
        this.chestTag = chestTag;
    }
}

