/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.TierCraftMenu;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.init.registry.enums.ModCraftTier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TierCraftTile
extends BaseInventoryTileEntity {
    private final ItemStackWrapper inventory;
    public ModCraftTier tier;

    public TierCraftTile(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModTileEntities.mod_craft_tile.get(), pos, blockState);
        if (blockState.is((Block)ModBlocks.sculk_crafting_table.get())) {
            this.tier = ModCraftTier.SCULK;
        } else if (blockState.is((Block)ModBlocks.nether_crafting_table.get())) {
            this.tier = ModCraftTier.NETHER;
        } else if (blockState.is((Block)ModBlocks.end_crafting_table.get())) {
            this.tier = ModCraftTier.END;
        } else if (blockState.is((Block)ModBlocks.extreme_crafting_table.get())) {
            this.tier = ModCraftTier.EXTREME;
        }
        this.inventory = new ItemStackWrapper(this.tier.size * this.tier.size, Integer.MAX_VALUE, this::setChangedAndDispatch);
        this.inventory.setOutputSlots(this.tier.size * this.tier.size);
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    @NotNull
    public Component getDisplayName() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pInventory) {
        switch (this.tier) {
            case SCULK: {
                return TierCraftMenu.sculk(pContainerId, pInventory, this.getBlockPos());
            }
            case END: {
                return TierCraftMenu.end(pContainerId, pInventory, this.getBlockPos());
            }
            case NETHER: {
                return TierCraftMenu.nether(pContainerId, pInventory, this.getBlockPos());
            }
            case EXTREME: {
                return TierCraftMenu.extreme(pContainerId, pInventory, this.getBlockPos());
            }
        }
        return TierCraftMenu.extreme(pContainerId, pInventory, this.getBlockPos());
    }
}

