/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.io;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class SideConfiguration {
    private SideMode north = SideMode.OFF;
    private SideMode south = SideMode.OFF;
    private SideMode east = SideMode.OFF;
    private SideMode west = SideMode.OFF;
    private SideMode up = SideMode.OFF;
    private SideMode down = SideMode.OFF;

    public SideConfiguration() {
    }

    public SideConfiguration(SideConfiguration other) {
        this.north = other.north;
        this.south = other.south;
        this.east = other.east;
        this.west = other.west;
        this.up = other.up;
        this.down = other.down;
    }

    public SideMode getSideMode(Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> this.north;
            case Direction.SOUTH -> this.south;
            case Direction.EAST -> this.east;
            case Direction.WEST -> this.west;
            case Direction.UP -> this.up;
            case Direction.DOWN -> this.down;
        };
    }

    public void setSideMode(Direction side, SideMode mode) {
        switch (side) {
            case NORTH: {
                this.north = mode;
                break;
            }
            case SOUTH: {
                this.south = mode;
                break;
            }
            case EAST: {
                this.east = mode;
                break;
            }
            case WEST: {
                this.west = mode;
                break;
            }
            case UP: {
                this.up = mode;
                break;
            }
            case DOWN: {
                this.down = mode;
            }
        }
    }

    public void cycleSideMode(Direction side) {
        SideMode current = this.getSideMode(side);
        SideMode[] modes = SideMode.values();
        int nextIndex = (current.ordinal() + 1) % modes.length;
        this.setSideMode(side, modes[nextIndex]);
    }

    public boolean canInput(Direction side) {
        return this.getSideMode(side).canInput();
    }

    public boolean canOutput(Direction side) {
        return this.getSideMode(side).canOutput();
    }

    public boolean isActive(Direction side) {
        return this.getSideMode(side).isActive();
    }

    public boolean isPassive(Direction side) {
        return this.getSideMode(side).isPassive();
    }

    public Direction[] getActiveInputSides() {
        return (Direction[])Direction.stream().filter(this::isActive).filter(this::canInput).toArray(Direction[]::new);
    }

    public Direction[] getActiveOutputSides() {
        return (Direction[])Direction.stream().filter(this::isActive).filter(this::canOutput).toArray(Direction[]::new);
    }

    public Direction[] getPassiveInputSides() {
        return (Direction[])Direction.stream().filter(this::isPassive).filter(this::canInput).toArray(Direction[]::new);
    }

    public Direction[] getPassiveOutputSides() {
        return (Direction[])Direction.stream().filter(this::isPassive).filter(this::canOutput).toArray(Direction[]::new);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("north", this.north.getName());
        tag.putString("south", this.south.getName());
        tag.putString("east", this.east.getName());
        tag.putString("west", this.west.getName());
        tag.putString("up", this.up.getName());
        tag.putString("down", this.down.getName());
        return tag;
    }

    public static SideConfiguration fromNBT(CompoundTag tag) {
        SideConfiguration config = new SideConfiguration();
        config.north = SideMode.fromName(tag.getString("north"));
        config.south = SideMode.fromName(tag.getString("south"));
        config.east = SideMode.fromName(tag.getString("east"));
        config.west = SideMode.fromName(tag.getString("west"));
        config.up = SideMode.fromName(tag.getString("up"));
        config.down = SideMode.fromName(tag.getString("down"));
        return config;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.north);
        buf.writeEnum((Enum)this.south);
        buf.writeEnum((Enum)this.east);
        buf.writeEnum((Enum)this.west);
        buf.writeEnum((Enum)this.up);
        buf.writeEnum((Enum)this.down);
    }

    public static SideConfiguration fromNetwork(FriendlyByteBuf buf) {
        SideConfiguration config = new SideConfiguration();
        config.north = (SideMode)buf.readEnum(SideMode.class);
        config.south = (SideMode)buf.readEnum(SideMode.class);
        config.east = (SideMode)buf.readEnum(SideMode.class);
        config.west = (SideMode)buf.readEnum(SideMode.class);
        config.up = (SideMode)buf.readEnum(SideMode.class);
        config.down = (SideMode)buf.readEnum(SideMode.class);
        return config;
    }

    public String toString() {
        return String.format("SideConfiguration{\u5317=%s, \u5357=%s, \u4e1c=%s, \u897f=%s, \u4e0a=%s, \u4e0b=%s}", new Object[]{this.north, this.south, this.east, this.west, this.up, this.down});
    }

    public static enum SideMode {
        OFF((Component)Component.translatable((String)"tooltip.avaritia.side.mode.off"), "off"),
        PASSIVE_INPUT((Component)Component.translatable((String)"tooltip.avaritia.side.mode.passive_input"), "passive_input"),
        PASSIVE_OUTPUT((Component)Component.translatable((String)"tooltip.avaritia.side.mode.passive_output"), "passive_output"),
        PASSIVE_MIXIN((Component)Component.translatable((String)"tooltip.avaritia.side.mode.passive_mixin"), "passive_mixin"),
        ACTIVE_INPUT((Component)Component.translatable((String)"tooltip.avaritia.side.mode.active_input"), "active_input"),
        ACTIVE_OUTPUT((Component)Component.translatable((String)"tooltip.avaritia.side.mode.active_output"), "active_output"),
        ACTIVE_MIXIN((Component)Component.translatable((String)"tooltip.avaritia.side.mode.active_mixin"), "active_mixin");

        private final Component displayName;
        private final String name;

        private SideMode(Component displayName, String name) {
            this.displayName = displayName;
            this.name = name;
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public boolean canInput() {
            return this == PASSIVE_INPUT || this == ACTIVE_INPUT || this == PASSIVE_MIXIN || this == ACTIVE_MIXIN;
        }

        public boolean canOutput() {
            return this == PASSIVE_OUTPUT || this == ACTIVE_OUTPUT || this == PASSIVE_MIXIN || this == ACTIVE_MIXIN;
        }

        public boolean isActive() {
            return this == ACTIVE_INPUT || this == ACTIVE_OUTPUT || this == ACTIVE_MIXIN;
        }

        public boolean isPassive() {
            return this == PASSIVE_INPUT || this == PASSIVE_OUTPUT || this == PASSIVE_MIXIN;
        }

        public boolean isMixed() {
            return this == PASSIVE_MIXIN || this == ACTIVE_MIXIN;
        }

        public static SideMode fromName(String name) {
            for (SideMode mode : SideMode.values()) {
                if (!mode.name.equals(name)) continue;
                return mode;
            }
            return OFF;
        }
    }
}

