/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.io;

import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TileIOHandler {
    private final BlockEntity tileEntity;
    private final DirectionProperty facing;

    public TileIOHandler(BlockEntity tileEntity, DirectionProperty facing) {
        this.tileEntity = tileEntity;
        this.facing = facing;
    }

    protected final Direction getRelativeDirection(Direction relativeSide, Direction blockFacing) {
        return switch (relativeSide) {
            case Direction.NORTH -> blockFacing;
            case Direction.SOUTH -> blockFacing.getOpposite();
            case Direction.EAST -> blockFacing.getCounterClockWise();
            case Direction.WEST -> blockFacing.getClockWise();
            case Direction.UP -> Direction.UP;
            case Direction.DOWN -> Direction.DOWN;
            default -> null;
        };
    }

    protected final Direction getRelativeDirectionFromAbsolute(Direction absoluteDirection, Direction blockFacing) {
        if (absoluteDirection == blockFacing) {
            return Direction.NORTH;
        }
        if (absoluteDirection == blockFacing.getOpposite()) {
            return Direction.SOUTH;
        }
        if (absoluteDirection == blockFacing.getCounterClockWise()) {
            return Direction.EAST;
        }
        if (absoluteDirection == blockFacing.getClockWise()) {
            return Direction.WEST;
        }
        if (absoluteDirection == Direction.UP) {
            return Direction.UP;
        }
        if (absoluteDirection == Direction.DOWN) {
            return Direction.DOWN;
        }
        return null;
    }

    protected final Direction getBlockFacing() {
        Level level = this.tileEntity.getLevel();
        BlockPos pos = this.tileEntity.getBlockPos();
        if (level != null && pos != null) {
            BlockState state = level.getBlockState(pos);
            if (this.facing != null && state.hasProperty((Property)this.facing)) {
                return (Direction)state.getValue((Property)this.facing);
            }
        }
        return null;
    }

    public void handleActiveIO() {
        Level level = this.tileEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof ITileIO) {
            ITileIO ITileIO2 = (ITileIO)blockEntity;
            SideConfiguration sideConfig = ITileIO2.getSideConfiguration();
            block5: for (Direction side : Direction.values()) {
                SideConfiguration.SideMode mode = sideConfig.getSideMode(side);
                if (mode == null || mode == SideConfiguration.SideMode.OFF) continue;
                switch (mode) {
                    case ACTIVE_INPUT: {
                        this.handleActiveInput(side);
                        continue block5;
                    }
                    case ACTIVE_OUTPUT: {
                        this.handleActiveOutput(side);
                        continue block5;
                    }
                    case ACTIVE_MIXIN: {
                        this.handleMixedIO(side);
                        continue block5;
                    }
                }
            }
        } else {
            return;
        }
    }

    protected void handleActiveInput(Direction side) {
        BlockEntity blockEntity;
        Direction blockFacing = this.getBlockFacing();
        if (blockFacing == null) {
            return;
        }
        Direction actualDirection = this.getRelativeDirection(side, blockFacing);
        if (actualDirection == null) {
            return;
        }
        BlockPos targetPos = this.tileEntity.getBlockPos().relative(actualDirection);
        Level level = this.tileEntity.getLevel();
        if (level != null && (blockEntity = this.tileEntity) instanceof ITileIO) {
            ITileIO ITileIO2 = (ITileIO)blockEntity;
            BlockEntity targetTile = level.getBlockEntity(targetPos);
            if (targetTile != null) {
                targetTile.getCapability(ForgeCapabilities.ITEM_HANDLER, actualDirection.getOpposite()).ifPresent(targetHandler -> ITileIO2.extractFromHandler((IItemHandler)targetHandler, actualDirection));
            }
        }
    }

    protected void handleActiveOutput(Direction side) {
        BlockEntity blockEntity;
        Direction blockFacing = this.getBlockFacing();
        if (blockFacing == null) {
            return;
        }
        Direction actualDirection = this.getRelativeDirection(side, blockFacing);
        if (actualDirection == null) {
            return;
        }
        BlockPos targetPos = this.tileEntity.getBlockPos().relative(actualDirection);
        Level level = this.tileEntity.getLevel();
        if (level != null && (blockEntity = this.tileEntity) instanceof ITileIO) {
            ITileIO ITileIO2 = (ITileIO)blockEntity;
            BlockEntity targetTile = level.getBlockEntity(targetPos);
            if (targetTile != null) {
                targetTile.getCapability(ForgeCapabilities.ITEM_HANDLER, actualDirection.getOpposite()).ifPresent(targetHandler -> ITileIO2.insertToHandler((IItemHandler)targetHandler, actualDirection));
            }
        }
    }

    protected void handleMixedIO(Direction side) {
        BlockEntity blockEntity;
        Direction blockFacing = this.getBlockFacing();
        if (blockFacing == null) {
            return;
        }
        Direction actualDirection = this.getRelativeDirection(side, blockFacing);
        if (actualDirection == null) {
            return;
        }
        BlockPos targetPos = this.tileEntity.getBlockPos().relative(actualDirection);
        Level level = this.tileEntity.getLevel();
        if (level != null && (blockEntity = this.tileEntity) instanceof ITileIO) {
            ITileIO ITileIO2 = (ITileIO)blockEntity;
            BlockEntity targetTile = level.getBlockEntity(targetPos);
            if (targetTile != null) {
                targetTile.getCapability(ForgeCapabilities.ITEM_HANDLER, actualDirection.getOpposite()).ifPresent(targetHandler -> ITileIO2.extractFromHandler((IItemHandler)targetHandler, actualDirection));
                targetTile.getCapability(ForgeCapabilities.ITEM_HANDLER, actualDirection.getOpposite()).ifPresent(targetHandler -> ITileIO2.insertToHandler((IItemHandler)targetHandler, actualDirection));
            }
        }
    }

    public boolean shouldAllowPassiveIO(@Nullable Direction side) {
        BlockEntity blockEntity;
        if (side == null) {
            return true;
        }
        Direction blockFacing = this.getBlockFacing();
        if (blockFacing != null && (blockEntity = this.tileEntity) instanceof ITileIO) {
            ITileIO tileIO = (ITileIO)blockEntity;
            Direction relativeSide = this.getRelativeDirectionFromAbsolute(side, blockFacing);
            if (relativeSide != null) {
                SideConfiguration.SideMode mode = tileIO.getSideConfiguration().getSideMode(relativeSide);
                return mode != SideConfiguration.SideMode.OFF;
            }
        }
        return false;
    }
}

