/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.singularity;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.core.singularity.SingularityReloadListener;
import committee.nova.mods.avaritia.init.config.ModConfig;
import dev.latvian.mods.rhino.Context;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.loading.FMLLoader;

public class Singularity {
    private final ResourceLocation registryName;
    private String displayName;
    private int overlayColor = 3876692;
    private int underlayColor = 3876692;
    private int count = Const.isLoad("projecte") ? 10000 : 1000;
    private int timeCost = FMLLoader.isProduction() ? (Integer)ModConfig.singularityTimeRequired.get() : 240;
    private Ingredient ingredient = Ingredient.EMPTY;
    private boolean enabled = true;
    private boolean recipeEnabled = true;
    private List<ICondition> conditions = new CopyOnWriteArrayList<ICondition>();

    public Singularity(ResourceLocation registryName, String displayName, int overlayColor, int underlayColor, int count, int timeCost, Ingredient ingredient, boolean enabled, boolean recipeEnable) {
        this.registryName = registryName;
        this.displayName = displayName;
        this.overlayColor = overlayColor;
        this.underlayColor = underlayColor;
        this.count = count;
        this.timeCost = timeCost;
        this.ingredient = ingredient;
        this.enabled = enabled;
        this.recipeEnabled = recipeEnable;
    }

    public Singularity(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public Singularity setColors(int overlayColor, int underlayColor) {
        this.overlayColor = overlayColor;
        this.underlayColor = underlayColor;
        return this;
    }

    public Singularity setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Singularity setCount(int count) {
        this.count = count;
        return this;
    }

    public Singularity setTimeCost(int timeCost) {
        this.timeCost = timeCost;
        return this;
    }

    public Singularity setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public Singularity setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Singularity setRecipeEnabled(boolean recipeEnable) {
        this.recipeEnabled = recipeEnable;
        return this;
    }

    public Singularity addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public static Singularity create(ResourceLocation registryName, String displayName, int[] colors, Ingredient ingredient, ICondition condition) {
        return Singularity.create(registryName, displayName, colors, ingredient).addCondition(condition);
    }

    public static Singularity create(ResourceLocation registryName, String displayName, int[] colors, Ingredient ingredient) {
        Singularity singularity = new Singularity(registryName);
        singularity.setDisplayName(displayName);
        singularity.setColors(colors[0], colors[1]);
        singularity.setIngredient(ingredient);
        return singularity;
    }

    public int getCount() {
        if (this.count == -1) {
            return 1000;
        }
        return this.count;
    }

    public static Singularity read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        String displayName = buffer.readUtf();
        int overlayColor = buffer.readInt();
        int underlayColor = buffer.readInt();
        Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        int timeCost = buffer.readVarInt();
        int count = buffer.readVarInt();
        boolean enabled = buffer.readBoolean();
        boolean recipeEnable = buffer.readBoolean();
        return new Singularity(id).setDisplayName(displayName).setColors(overlayColor, underlayColor).setIngredient(ingredient).setCount(count).setTimeCost(timeCost).setEnabled(enabled).setRecipeEnabled(recipeEnable);
    }

    public static void write(FriendlyByteBuf buffer, Singularity singularity) {
        buffer.writeResourceLocation(singularity.registryName);
        buffer.writeUtf(singularity.displayName);
        buffer.writeInt(singularity.overlayColor);
        buffer.writeInt(singularity.underlayColor);
        singularity.getIngredient().toNetwork(buffer);
        buffer.writeVarInt(singularity.timeCost);
        buffer.writeVarInt(singularity.getCount());
        buffer.writeBoolean(singularity.enabled);
        buffer.writeBoolean(singularity.recipeEnabled);
    }

    public static Singularity wrap(Context context, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Singularity) {
            return (Singularity)object;
        }
        if (object instanceof ResourceLocation) {
            return SingularityReloadListener.INSTANCE.getSingularity((ResourceLocation)object);
        }
        if (object instanceof String) {
            return SingularityReloadListener.INSTANCE.getSingularity(ResourceLocation.tryParse((String)((String)object)));
        }
        throw new IllegalArgumentException("Cannot convert object to Singularity: " + String.valueOf(object));
    }

    @Generated
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public int getOverlayColor() {
        return this.overlayColor;
    }

    @Generated
    public int getUnderlayColor() {
        return this.underlayColor;
    }

    @Generated
    public int getTimeCost() {
        return this.timeCost;
    }

    @Generated
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isRecipeEnabled() {
        return this.recipeEnabled;
    }

    @Generated
    public List<ICondition> getConditions() {
        return this.conditions;
    }
}

