/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.singularity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityEvent;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class SingularityReloadListener
extends SimpleJsonResourceReloadListener {
    public static SingularityReloadListener INSTANCE = new SingularityReloadListener();
    public ICondition.IContext context;
    private Map<ResourceLocation, Singularity> dataSingularities = Maps.newConcurrentMap();
    private Map<ResourceLocation, Singularity> runSingularities = Maps.newConcurrentMap();
    private List<ResourceLocation> removeRecipes = Lists.newCopyOnWriteArrayList();
    private List<ResourceLocation> removeSingularities = Lists.newCopyOnWriteArrayList();
    private boolean removeAllRecipes = false;
    private boolean removeAll = false;

    public SingularityReloadListener() {
        super(Const.GSON, "singularities");
    }

    public SingularityReloadListener(ICondition.IContext context) {
        super(Const.GSON, "singularities");
        this.context = context;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.getPath().startsWith("_")) continue;
            try {
                if (entry.getValue().isJsonObject() && !CraftingHelper.processConditions((JsonObject)entry.getValue().getAsJsonObject(), (String)"conditions", (ICondition.IContext)this.context)) {
                    Const.LOGGER.debug("Singularity: Skipping loading singularity {} as it's conditions were not met", (Object)resourcelocation);
                    continue;
                }
                Singularity singularity = SingularityUtils.loadFromJson(GsonHelper.convertToJsonObject((JsonElement)entry.getValue(), (String)"top element"));
                if (singularity == null) {
                    Const.LOGGER.info("Singularity: Skipping loading singularity {} as it's serializer returned null", (Object)resourcelocation);
                    continue;
                }
                this.dataSingularities.put(resourcelocation, singularity);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                Const.LOGGER.error("Singularity: Parsing error loading singularity {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.onSingularitiesReloaded(this.getAllSingularities());
    }

    public Map<ResourceLocation, Singularity> getAllSingularities() {
        ConcurrentHashMap<ResourceLocation, Singularity> all = new ConcurrentHashMap<ResourceLocation, Singularity>(this.dataSingularities);
        all.putAll(this.runSingularities);
        all.forEach((id, singularity) -> {
            if (this.removeRecipes.contains(id)) {
                ((Singularity)all.get(id)).setRecipeEnabled(false);
            }
            if (this.removeSingularities.contains(id)) {
                all.remove(id);
            }
        });
        if (this.removeAllRecipes) {
            all.forEach((id, singularity) -> singularity.setRecipeEnabled(false));
        }
        if (this.removeAll) {
            all.clear();
        }
        return all;
    }

    public void registerSingularity(Singularity singularity) {
        if (singularity != null && singularity.getRegistryName() != null) {
            Singularity oldSingularity = this.runSingularities.put(singularity.getRegistryName(), singularity);
            if (oldSingularity == null) {
                Const.LOGGER.info("Singularity: Registered runtime singularity: {}", (Object)singularity.getRegistryName());
            } else {
                Const.LOGGER.info("Singularity: Updated runtime singularity: {}", (Object)singularity.getRegistryName());
            }
            MinecraftForge.EVENT_BUS.post((Event)new SingularityEvent.Add(this.runSingularities, singularity));
        }
    }

    public void removeSingularityRecipe(ResourceLocation id) {
        this.removeRecipes.add(id);
    }

    public void removeSingularity(ResourceLocation id) {
        this.removeSingularities.add(id);
        MinecraftForge.EVENT_BUS.post((Event)new SingularityEvent.Remove(this.getAllSingularities(), id));
    }

    public Singularity getSingularity(ResourceLocation id) {
        Singularity runtimeSingularity = this.runSingularities.get(id);
        if (runtimeSingularity != null) {
            return runtimeSingularity;
        }
        return this.dataSingularities.get(id);
    }

    private void onSingularitiesReloaded(Map<ResourceLocation, Singularity> singularities) {
        InfinityCatalystCraftRecipe.INGREDIENTS_LOADED.clear();
        EternalSingularityCraftRecipe.INGREDIENTS_LOADED.clear();
        MinecraftForge.EVENT_BUS.post((Event)new SingularityEvent.Reload(singularities));
    }

    @NotNull
    public String getName() {
        return "Avaritia Singularity Listener";
    }

    @Generated
    public Map<ResourceLocation, Singularity> getDataSingularities() {
        return this.dataSingularities;
    }

    @Generated
    public void setDataSingularities(Map<ResourceLocation, Singularity> dataSingularities) {
        this.dataSingularities = dataSingularities;
    }

    @Generated
    public Map<ResourceLocation, Singularity> getRunSingularities() {
        return this.runSingularities;
    }

    @Generated
    public void setRunSingularities(Map<ResourceLocation, Singularity> runSingularities) {
        this.runSingularities = runSingularities;
    }

    @Generated
    public List<ResourceLocation> getRemoveRecipes() {
        return this.removeRecipes;
    }

    @Generated
    public void setRemoveRecipes(List<ResourceLocation> removeRecipes) {
        this.removeRecipes = removeRecipes;
    }

    @Generated
    public List<ResourceLocation> getRemoveSingularities() {
        return this.removeSingularities;
    }

    @Generated
    public void setRemoveSingularities(List<ResourceLocation> removeSingularities) {
        this.removeSingularities = removeSingularities;
    }

    @Generated
    public boolean isRemoveAllRecipes() {
        return this.removeAllRecipes;
    }

    @Generated
    public void setRemoveAllRecipes(boolean removeAllRecipes) {
        this.removeAllRecipes = removeAllRecipes;
    }

    @Generated
    public boolean isRemoveAll() {
        return this.removeAll;
    }

    @Generated
    public void setRemoveAll(boolean removeAll) {
        this.removeAll = removeAll;
    }
}

