/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.curios;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosTools {
    public static ItemStack getFirstItemFromCuriosInv(Player player, Predicate<ItemStack> filter) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.findFirstCurio(filter).map(SlotResult::stack).orElse(ItemStack.EMPTY)).orElse(ItemStack.EMPTY);
    }

    public static ICapabilityProvider getSlowProvider(final ItemStack stack) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.level().isClientSide) {
                        player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, -1, 2, false, true));
                        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 2, false, true));
                        ArrayList effects = Lists.newArrayList((Iterable)player.getActiveEffects());
                        for (MobEffectInstance potion2 : Collections2.filter((Collection)effects, potion -> potion.getEffect().equals(MobEffects.MOVEMENT_SLOWDOWN) || potion.getEffect().equals(MobEffects.DIG_SLOWDOWN))) {
                            player.removeEffect(potion2.getEffect());
                        }
                    }
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }
}

