/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.kubejs;

import com.google.common.base.Stopwatch;
import committee.nova.mods.avaritia.api.Lib;
import committee.nova.mods.avaritia.api.init.event.RegisterRecipesEvent;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.init.compat.kubejs.CompressRecipeSchema;
import committee.nova.mods.avaritia.init.compat.kubejs.EternalSingularityRecipeSchema;
import committee.nova.mods.avaritia.init.compat.kubejs.ExtremeSmithingRecipeSchema;
import committee.nova.mods.avaritia.init.compat.kubejs.InfinityCatalystRecipeSchema;
import committee.nova.mods.avaritia.init.compat.kubejs.ShapedTableRecipeSchema;
import committee.nova.mods.avaritia.init.compat.kubejs.ShapelessTableRecipeSchema;
import committee.nova.mods.avaritia.init.compat.kubejs.event.AvaritiaEvents;
import committee.nova.mods.avaritia.init.compat.kubejs.event.SingularityRegisterEventJS;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class KubeJSAvaritiaPlugin
extends KubeJSPlugin {
    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        event.register(ModRecipeSerializers.SHAPED_CRAFT_SERIALIZER.getId(), ShapedTableRecipeSchema.SCHEMA);
        event.register(ModRecipeSerializers.SHAPELESS_CRAFT_SERIALIZER.getId(), ShapelessTableRecipeSchema.SCHEMA);
        event.register(ModRecipeSerializers.COMPRESSOR_SERIALIZER.getId(), CompressRecipeSchema.SCHEMA);
        event.register(ModRecipeSerializers.INFINITY_CATALYST_CRAFT_SERIALIZER.getId(), InfinityCatalystRecipeSchema.SCHEMA);
        event.register(ModRecipeSerializers.ETERNAL_SINGULARITY_CRAFT_SERIALIZER.getId(), EternalSingularityRecipeSchema.SCHEMA);
        event.register(ModRecipeSerializers.EXTREME_SMITHING_SERIALIZER.getId(), ExtremeSmithingRecipeSchema.SCHEMA);
    }

    public void registerBindings(BindingsEvent event) {
        event.add("Singularity", Singularity.class);
    }

    public void registerEvents() {
        AvaritiaEvents.GROUP.register();
    }

    public void injectRuntimeRecipes(RecipesEventJS event, RecipeManager manager, Map<ResourceLocation, Recipe<?>> recipesByName) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        CopyOnWriteArrayList addRecipes = new CopyOnWriteArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RegisterRecipesEvent(manager, addRecipes));
        }
        catch (Exception e) {
            Lib.LOGGER.error("Avaritia: An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (Recipe<?> recipe : addRecipes) {
            recipesByName.put(recipe.getId(), recipe);
        }
        Lib.LOGGER.info("Avaritia: Registered {} recipes in {} ms (KubeJS mode)", (Object)addRecipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        SingularityRegisterEventJS registerEventJS = new SingularityRegisterEventJS();
        AvaritiaEvents.REGISTRY.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)registerEventJS);
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.register(Singularity.class, Singularity::wrap);
    }
}

