/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.provider.base;

import com.google.gson.JsonElement;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public abstract class SingularityProvider
implements DataProvider {
    private final DataGenerator generator;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final PackOutput.PathProvider pathProvider;
    private final ExistingFileHelper fileHelper;
    private final Map<ResourceLocation, Singularity> singularities = new TreeMap<ResourceLocation, Singularity>();

    public SingularityProvider(DataGenerator generator, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper fileHelper) {
        this.generator = generator;
        this.registries = registries;
        this.pathProvider = generator.getPackOutput().createPathProvider(PackOutput.Target.DATA_PACK, "singularities");
        this.fileHelper = fileHelper;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput output) {
        return this.registries.thenCompose(provider -> {
            ArrayList list = new ArrayList();
            this.generate((HolderLookup.Provider)provider, this.fileHelper);
            this.singularities.forEach((res, singularity) -> list.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)SingularityUtils.writeToJson(singularity), (Path)this.pathProvider.json(res))));
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public abstract void generate(HolderLookup.Provider var1, ExistingFileHelper var2);

    public final void addSingularity(List<Singularity> singularities) {
        this.singularities.putAll(singularities.stream().collect(Collectors.toMap(Singularity::getRegistryName, s -> s)));
    }

    public final void addSingularity(Singularity singularities) {
        this.singularities.put(singularities.getRegistryName(), singularities);
    }

    @NotNull
    public String getName() {
        return "Avaritia Singularities Data Provider";
    }
}

