/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.mixins;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import committee.nova.mods.avaritia.api.Lib;
import committee.nova.mods.avaritia.api.init.event.RegisterRecipesEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class}, priority=1101)
public abstract class RecipeManagerMixin
extends SimpleJsonResourceReloadListener {
    @Shadow
    public Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> recipes;
    @Shadow
    public Map<ResourceLocation, Recipe<?>> byName;

    public RecipeManagerMixin(Gson gson, String directory) {
        super(gson, directory);
    }

    @Inject(at={@At(value="TAIL")}, method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"})
    public void avaritia$apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        RecipeManager manager = (RecipeManager)this;
        Lib.LOGGER.info("Avaritia: Loading recipes...");
        ConcurrentMap newRecipes = Maps.newConcurrentMap();
        this.recipes.forEach((type, map) -> newRecipes.put(type, new ConcurrentHashMap(map)));
        ConcurrentHashMap newByName = new ConcurrentHashMap(this.byName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        CopyOnWriteArrayList recipes = new CopyOnWriteArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RegisterRecipesEvent(manager, recipes));
        }
        catch (Exception e) {
            Lib.LOGGER.error("An error occurred while firing RegisterRecipesEvent", (Throwable)e);
        }
        for (Recipe<?> recipe : recipes) {
            RecipeType recipeType = recipe.getType();
            Map recipeMap = (Map)newRecipes.get(recipeType);
            if (!newRecipes.containsKey(recipeType)) {
                recipeMap = Maps.newConcurrentMap();
            }
            recipeMap.put(recipe.getId(), recipe);
            newRecipes.put(recipe.getType(), recipeMap);
            newByName.put(recipe.getId(), recipe);
        }
        this.recipes = ImmutableMap.copyOf((Map)newRecipes);
        this.byName = ImmutableMap.copyOf(newByName);
        Lib.LOGGER.info("Avaritia: Registered {} recipes in {} ms", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }
}

