/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IngredientUtils {
    private final IMappingCollector<NormalizedSimpleStack, Long> mapper;
    private Map<NormalizedSimpleStack, Integer> ingredientMap = new HashMap<NormalizedSimpleStack, Integer>();
    private boolean isValid = true;

    public IngredientUtils(IMappingCollector<NormalizedSimpleStack, Long> mapper) {
        this.mapper = mapper;
    }

    public void resetHelper() {
        this.isValid = true;
        this.ingredientMap = new HashMap<NormalizedSimpleStack, Integer>();
    }

    public void put(NormalizedSimpleStack stack, int amount) {
        if (this.isValid) {
            if (this.ingredientMap.containsKey(stack)) {
                long newAmount = (long)this.ingredientMap.get(stack).intValue() + (long)amount;
                if (newAmount <= Integer.MAX_VALUE && newAmount >= Integer.MIN_VALUE) {
                    this.ingredientMap.put(stack, (int)newAmount);
                } else {
                    this.isValid = false;
                }
            } else {
                this.ingredientMap.put(stack, amount);
            }
        }
    }

    public void put(NormalizedSimpleStack stack, long amount) {
        if (amount <= Integer.MAX_VALUE && amount >= Integer.MIN_VALUE) {
            this.put(stack, (int)amount);
        } else {
            this.isValid = false;
        }
    }

    public void put(FluidStack stack) {
        this.put((NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
    }

    public void put(ItemStack stack) {
        this.put((NormalizedSimpleStack)NSSItem.createItem((ItemStack)stack), stack.getCount());
    }

    public boolean addAsConversion(NormalizedSimpleStack output, int outputAmount) {
        if (this.isValid) {
            this.mapper.addConversion(outputAmount, (Object)output, this.ingredientMap);
            return true;
        }
        return false;
    }

    public boolean addAsConversion(NormalizedSimpleStack output, long outputAmount) {
        return outputAmount <= Integer.MAX_VALUE && this.addAsConversion(output, (int)outputAmount);
    }

    public boolean addAsConversion(FluidStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
    }

    public boolean addAsConversion(ItemStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSItem.createItem((ItemStack)stack), stack.getCount());
    }
}

