/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.util.NBTUtils;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityReloadListener;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class SingularityUtils {
    public static Singularity loadFromJson(JsonObject json) {
        String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
        String displayName = GsonHelper.getAsString((JsonObject)json, (String)"displayName");
        int materialCount = Const.isLoad("projecte") ? 10000 : GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1000);
        int overlayColor = Integer.parseInt(GsonHelper.getAsString((JsonObject)json, (String)"overlayColor"), 16);
        int underlayColor = Integer.parseInt(GsonHelper.getAsString((JsonObject)json, (String)"underlayColor"), 16);
        JsonObject ing = GsonHelper.getAsJsonObject((JsonObject)json, (String)"ingredient", null);
        int time = GsonHelper.getAsInt((JsonObject)json, (String)"timeRequired", (int)((Integer)ModConfig.singularityTimeRequired.get()));
        boolean enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
        boolean recipeDisabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"recipeDisabled", (boolean)false);
        return Singularity.create(ResourceLocation.parse((String)name), displayName, new int[]{overlayColor, underlayColor}, ing == null ? Ingredient.EMPTY : Ingredient.fromJson((JsonElement)ing)).setTimeCost(time).setCount(materialCount).setEnabled(enabled).setRecipeEnabled(recipeDisabled);
    }

    public static JsonObject writeToJson(Singularity singularity) {
        JsonObject json = new JsonObject();
        json.addProperty("name", singularity.getRegistryName().toString());
        json.addProperty("displayName", singularity.getDisplayName());
        json.addProperty("overlayColor", Integer.toString(singularity.getOverlayColor(), 16));
        json.addProperty("underlayColor", Integer.toString(singularity.getUnderlayColor(), 16));
        json.addProperty("count", (Number)singularity.getCount());
        json.addProperty("timeCost", (Number)singularity.getTimeCost());
        json.add("ingredient", singularity.getIngredient().toJson());
        json.addProperty("enabled", Boolean.valueOf(singularity.isEnabled()));
        json.addProperty("recipeDisabled", Boolean.valueOf(singularity.isRecipeEnabled()));
        json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])((ICondition[])singularity.getConditions().toArray(ICondition[]::new))));
        return json;
    }

    public static CompoundTag makeTag(Singularity singularity) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Id", singularity.getRegistryName().toString());
        return nbt;
    }

    public static ItemStack getItemForSingularity(Singularity singularity) {
        CompoundTag nbt = SingularityUtils.makeTag(singularity);
        ItemStack stack = new ItemStack((ItemLike)ModItems.singularity.get());
        stack.setTag(nbt);
        return stack;
    }

    public static Singularity getSingularity(ItemStack stack) {
        String id = NBTUtils.getString(stack, "Id");
        if (!id.isEmpty()) {
            return SingularityReloadListener.INSTANCE.getSingularity(ResourceLocation.tryParse((String)id));
        }
        return null;
    }
}

